package dev.zenfyr.andromeda.modules.items.lava_disintegrator.mixin;

import dev.zenfyr.pulsar.client.particles.ScreenParticleHelper;
import dev.zenfyr.pulsar.util.MathUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1792.class)
abstract class ItemMixin {

  @Inject(at = @At("HEAD"), method = "overrideOtherStackedOnMe", cancellable = true)
  private void andromeda$onLavaClick(
      class_1799 stack,
      class_1799 otherStack,
      class_1735 slot,
      class_5536 clickType,
      class_1657 player,
      class_5630 cursorStackReference,
      CallbackInfoReturnable<Boolean> cir) {
    if (clickType == class_5536.field_27014 && stack.method_31574(class_1802.field_8187)) {
      if (otherStack.method_7909().method_24358()
          || class_1890.method_8225(class_1893.field_9095, otherStack)
              > 0) return;

      cursorStackReference.method_32332(class_1799.field_8037);
      if (player.field_6002.field_9236)
        spawnLavaParticles((int) Math.max(2, Math.sqrt(otherStack.method_7947())));
      cir.setReturnValue(true);
    }
  }

  @Unique @Environment(EnvType.CLIENT)
  private static void spawnLavaParticles(int count) {
    var client = class_310.method_1551();
    int x = (int) (client.field_1729.method_1603()
        * (double) client.method_22683().method_4486()
        / (double) client.method_22683().method_4480());
    int y = (int) (client.field_1729.method_1604()
        * (double) client.method_22683().method_4502()
        / (double) client.method_22683().method_4507());
    for (int i = 0; i < count; i++) {
      ScreenParticleHelper.addParticle(class_2398.field_11239, x, y, 0.0, 0.0);
    }
    Objects.requireNonNull(client.field_1724)
        .method_17356(
            class_3417.field_19198,
            class_3419.field_15256,
            0.8f,
            0.8F + MathUtil.threadRandom().nextFloat() * 0.4F);
  }
}
