package dev.zenfyr.andromeda.modules.items.lockpick;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.blocks.guarded_loot.GuardedLoot;
import dev.zenfyr.andromeda.modules.blocks.guarded_loot.Main;
import dev.zenfyr.pulsar.util.MathUtil;
import dev.zenfyr.pulsar.util.TextUtil;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3917;
import net.minecraft.class_3988;
import net.minecraft.class_747;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class LockpickItem extends class_1792 {

  public static final Keeper<LockpickItem> INSTANCE = Keeper.create();

  public LockpickItem(class_1793 settings) {
    super(settings);
  }

  public boolean tryUse(class_1799 stack, class_1309 user, class_1268 hand) {
    var c = user.field_6002.am$get(Lockpick.CONFIG);
    if (c.available && hand == class_1268.field_5808) {
      if (!(user instanceof class_1657 p && p.method_31549().field_7477)) {
        if (c.breakAfterUse) {
          if (!user.field_6002.method_8608()) user.method_20235(class_1304.field_6173);

          stack.method_7934(1);
        }
      }

      return c.chance - 1 == 0 || MathUtil.threadRandom().nextInt(c.chance - 1) == 0;
    }
    return false;
  }

  @Override
  public class_1269 method_7847(
      class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
    if (user.field_6002.method_8608()) return class_1269.field_5812;

    if (entity instanceof class_3988 merchant
        && Andromeda.MAIN.get(Lockpick.MAIN_CONFIG).villagerInventory) {
      if (tryUse(stack, user, hand)) {
        user.method_17355(new class_747(
            (syncId, inv, player) ->
                new MerchantInventoryScreenHandler(syncId, inv, merchant.method_35199()),
            TextUtil.translatable("gui.andromeda.merchant")));
        return class_1269.field_5812;
      }
    }
    return class_1269.field_21466;
  }

  static void init() {
    var module = ModuleManager.get().get(Lockpick.class).orElseThrow();
    var config = Andromeda.MAIN.get(Lockpick.MAIN_CONFIG);

    LockpickItem.INSTANCE.init(class_2378.method_10230(
        class_7923.field_41178,
        id("lockpick"),
        new LockpickItem(new FabricItemSettings().method_7889(16))));

    if (config.villagerInventory) {
      MerchantInventoryScreenHandler.INSTANCE.init(class_2378.method_10230(
          class_7923.field_41187,
          id("merchant_inventory"),
          new class_3917<>(MerchantInventoryScreenHandler::new, class_7699.method_45397())));
    }

    AndromedaItemGroup.BUS.listen(acceptor ->
        acceptor.keeper(module, class_7706.field_41060, LockpickItem.INSTANCE));

    ModuleManager.get().get(GuardedLoot.class).ifPresent(gl -> {
      Main.UNLOCKERS.add((blockEntity, player) -> {
        if (player.field_6002.am$get(GuardedLoot.CONFIG).allowLockPicking) {
          if (player.method_6047().method_31574(LockpickItem.INSTANCE.orThrow())) {
            return LockpickItem.INSTANCE
                .orThrow()
                .tryUse(player.method_6047(), player, class_1268.field_5808);
          }
        }
        return false;
      });
    });
  }
}
