package dev.zenfyr.andromeda.modules.items.minecart_block_picking;

import dev.zenfyr.pulsar.nbt.CompoundTagBuilder;
import dev.zenfyr.pulsar.nbt.NbtUtil;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.IdentityHashMap;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2595;
import net.minecraft.class_2609;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PickUpBehaviorHandler {

  private static final IdentityHashMap<class_2248, PickUpBehavior> PICK_UP_BEHAVIOR_MAP =
      new IdentityHashMap<>();

  public static void registerPickUpBehavior(class_2248 block, PickUpBehavior pickUpBehavior) {
    PICK_UP_BEHAVIOR_MAP.put(block, pickUpBehavior);
  }

  public static Optional<PickUpBehavior> getPickUpBehavior(class_2248 block) {
    return Optional.ofNullable(PICK_UP_BEHAVIOR_MAP.get(block));
  }

  public static void init() {
    registerPickUpBehavior(class_2246.field_10034, (state, world, pos) -> {
      class_2595 chestBlockEntity = (class_2595) MakeSure.notNull(
          world.method_8321(pos), "Block has no block entity. %s".formatted(pos));
      class_1799 chestMinecart = new class_1799(class_1802.field_8388, 1);

      chestMinecart.method_7980(NbtUtil.writeInventoryToTag(new class_2487(), chestBlockEntity));
      chestBlockEntity.method_5448();
      return chestMinecart;
    });

    registerPickUpBehavior(class_2246.field_10375, (state, world, pos) -> new class_1799(class_1802.field_8069, 1));

    registerPickUpBehavior(class_2246.field_10181, (state, world, pos) -> {
      class_2609 furnaceBlock = (class_2609) MakeSure.notNull(
          world.method_8321(pos), "Block has no block entity. %s".formatted(pos));
      class_1799 furnaceMinecart = new class_1799(class_1802.field_8063, 1);
      // 2.25
      furnaceMinecart.method_7980(CompoundTagBuilder.create()
          .putInt("Fuel", (int) (furnaceBlock.field_11981 * 2.25))
          .build());
      return furnaceMinecart;
    });

    registerPickUpBehavior(class_2246.field_10312, (state, world, pos) -> {
      class_2614 hopperBlockEntity = (class_2614) MakeSure.notNull(
          world.method_8321(pos), "Block has no block entity. %s".formatted(pos));
      class_1799 hopperMinecart = new class_1799(class_1802.field_8836, 1);

      hopperMinecart.method_7980(NbtUtil.writeInventoryToTag(new class_2487(), hopperBlockEntity));
      hopperBlockEntity.method_5448();
      return hopperMinecart;
    });
  }

  public interface PickUpBehavior {
    @Nullable class_1799 pickUp(class_2680 state, class_1937 world, class_2338 pos);
  }
}
