package dev.zenfyr.andromeda.modules.items.minecart_block_picking;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.modules.entities.furnace_minecart_tweaks.FurnaceMinecartTweaks;
import dev.zenfyr.pulsar.nbt.NbtUtil;
import java.util.IdentityHashMap;
import java.util.Optional;
import net.minecraft.class_1688;
import net.minecraft.class_1694;
import net.minecraft.class_1696;
import net.minecraft.class_1700;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class PlaceBehaviorHandler {

  private static final IdentityHashMap<class_1792, PlaceBehavior> PLACE_BEHAVIOR_MAP =
      new IdentityHashMap<>();

  public static void registerPlaceBehavior(class_1792 item, PlaceBehavior placeBehavior) {
    PLACE_BEHAVIOR_MAP.put(item, placeBehavior);
  }

  public static Optional<PlaceBehavior> getPlaceBehavior(class_1792 item) {
    return Optional.ofNullable(PLACE_BEHAVIOR_MAP.get(item));
  }

  public static void init() {
    registerPlaceBehavior(class_1802.field_8388, (stack, world, d, e, f, g, pos) -> {
      class_1694 chestMinecart = (class_1694)
          class_1688.method_7523(world, d, e + g, f, class_1688.class_1689.field_7678);

      NbtUtil.readInventoryFromTag(stack.method_7969(), chestMinecart);
      if (stack.method_7938()) chestMinecart.method_5665(stack.method_7964());
      return chestMinecart;
    });

    registerPlaceBehavior(class_1802.field_8836, (stack, world, d, e, f, g, pos) -> {
      class_1700 hopperMinecart = (class_1700)
          class_1688.method_7523(world, d, e + g, f, class_1688.class_1689.field_7677);

      NbtUtil.readInventoryFromTag(stack.method_7969(), hopperMinecart);
      if (stack.method_7938()) hopperMinecart.method_5665(stack.method_7964());
      return hopperMinecart;
    });

    registerPlaceBehavior(class_1802.field_8063, (stack, world, d, e, f, g, pos) -> {
      class_1696 furnaceMinecart = (class_1696)
          class_1688.method_7523(world, d, e + g, f, class_1688.class_1689.field_7679);

      furnaceMinecart.field_7739 = NbtUtil.getInt(
          stack.method_7969(),
          "Fuel",
          0,
          ModuleManager.get()
              .get(FurnaceMinecartTweaks.class)
              .map(m -> Andromeda.MAIN.get(FurnaceMinecartTweaks.CONFIG).maxFuel)
              .orElse(32000));
      if (furnaceMinecart.field_7739 > 0) {
        furnaceMinecart.field_7737 = furnaceMinecart.method_23317() - pos.method_10263();
        furnaceMinecart.field_7736 = furnaceMinecart.method_23321() - pos.method_10260();
      }
      if (stack.method_7938()) furnaceMinecart.method_5665(stack.method_7964());

      return furnaceMinecart;
    });
  }

  public interface PlaceBehavior {
    class_1688 dispense(
        class_1799 stack, class_1937 world, double d, double e, double f, double g, class_2338 pos);
  }
}
