package dev.zenfyr.andromeda.modules.items.pouches;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.items.pouches.entities.PouchEntity;
import dev.zenfyr.andromeda.modules.items.pouches.items.PouchItem;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import dev.zenfyr.pulsar.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.util.*;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2965;
import net.minecraft.class_4048;
import net.minecraft.class_5561;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class Main {

  public static final Keeper<PouchItem> SEED_POUCH = Keeper.create();
  public static final Keeper<PouchItem> FLOWER_POUCH = Keeper.create();
  public static final Keeper<PouchItem> SAPLING_POUCH = Keeper.create();
  public static final Keeper<PouchItem> SPECIAL_POUCH = Keeper.create();
  public static final Keeper<class_1299<PouchEntity>> POUCH = Keeper.create();

  private static final Map<class_2591<?>, Field> VIEWABLE_BLOCKS = new HashMap<>();
  public static final Map<class_2591<?>, Field> VIEWABLE_VIEW =
      Collections.unmodifiableMap(VIEWABLE_BLOCKS);

  public static int getViewCount(class_2586 be) {
    Field f = Main.VIEWABLE_VIEW.get(be.method_11017());
    if (f != null) {
      class_5561 vcm = (class_5561) ExceptionUtil.supply(() -> f.get(be));
      return vcm.method_31678();
    }
    return -1;
  }

  @SuppressWarnings("UnstableApiUsage")
  public static void tryInsertItem(
      class_1937 world, class_243 pos, class_1799 stack, Storage<ItemVariant> storage) {
    if (stack.method_7960()) return;
    class_1799 itemStack = stack.method_7972();
    try (Transaction transaction = Transaction.openOuter()) {
      long i = StorageUtil.tryInsertStacking(
          storage, ItemVariant.of(stack), stack.method_7947(), transaction);
      if (i > 0) {
        transaction.commit();
        itemStack.method_7939((int) (stack.method_7947() - i));
      }
    }
    if (!itemStack.method_7960())
      ItemStackUtil.spawnVelocity(pos, itemStack, world, -0.2, 0.2, 0.1, 0.2, -0.2, 0.2);
  }

  static void init() {
    var module = ModuleManager.get().get(Pouches.class).orElseThrow();
    var config = Andromeda.MAIN.get(Pouches.MAIN_CONFIG);

    if (config.seedPouch) {
      SEED_POUCH.init(class_2378.method_10230(
          class_7923.field_41178,
          id("seed_pouch"),
          new PouchItem(PouchEntity.Type.SEED, new FabricItemSettings().method_7889(16))));
    }

    if (config.flowerPouch) {
      FLOWER_POUCH.init(class_2378.method_10230(
          class_7923.field_41178,
          id("flower_pouch"),
          new PouchItem(PouchEntity.Type.FLOWER, new FabricItemSettings().method_7889(16))));
    }

    if (config.saplingPouch) {
      SAPLING_POUCH.init(class_2378.method_10230(
          class_7923.field_41178,
          id("sapling_pouch"),
          new PouchItem(PouchEntity.Type.SAPLING, new FabricItemSettings().method_7889(16))));
    }

    if (config.specialPouch) {
      SPECIAL_POUCH.init(class_2378.method_10230(
          class_7923.field_41178,
          id("special_pouch"),
          new PouchItem(PouchEntity.Type.CUSTOM, new FabricItemSettings().method_7889(16))));
    }

    POUCH.init(class_2378.method_10230(
        class_7923.field_41177,
        id("pouch"),
        FabricEntityTypeBuilder.<PouchEntity>create(class_1311.field_17715, PouchEntity::new)
            .dimensions(new class_4048(0.25F, 0.25F, true))
            .trackRangeChunks(4)
            .trackedUpdateRate(10)
            .build()));

    Trades.register();

    List<Keeper<PouchItem>> l = List.of(SEED_POUCH, FLOWER_POUCH, SAPLING_POUCH, SPECIAL_POUCH);
    AndromedaItemGroup.BUS.listen(acceptor ->
        acceptor.keepers(module, class_7706.field_41060, new ArrayList<>(l)));

    var behavior = new class_2965() {
      @Override
      protected class_1676 method_12844(class_1937 world, class_2374 position, class_1799 stack) {
        var pouch = new PouchEntity(position.method_10216(), position.method_10214(), position.method_10215(), world);
        pouch.setPouchType(((PouchItem) stack.method_7909()).getType());
        return pouch;
      }
    };

    for (Keeper<PouchItem> pouchItemKeeper : l) {
      if (pouchItemKeeper.isPresent())
        class_2315.method_10009(pouchItemKeeper.orThrow(), behavior);
    }
  }

  private static void test(class_2586 be, Pouches module) {
    if (be != null) {
      Field f = traverse(be.getClass());
      if (f != null) {
        try {
          f.setAccessible(true);
          VIEWABLE_BLOCKS.put(be.method_11017(), f);
        } catch (Exception e) {
          module.logger().error("{}: {}", e.getClass(), e.getLocalizedMessage());
        }
      }
    }
  }

  private static @Nullable Field traverse(Class<?> cls) {
    for (Field f : cls.getDeclaredFields()) {
      if (f.getType() == class_5561.class) {
        return f;
      }
    }
    if (cls.getSuperclass() != null) return traverse(cls.getSuperclass());
    return null;
  }

  static void testBlocks() {
    var module = ModuleManager.get().get(Pouches.class).orElseThrow();
    for (class_2591<?> type : class_7923.field_41181) {
      var o = type.field_19315.stream().findAny();
      if (o.isPresent()) {
        try {
          test(type.method_11032(class_2338.field_10980, o.orElseThrow().method_9564()), module);
        } catch (Exception e) {
          module
              .logger()
              .error(
                  "{} failed the ViewerCountManager test. {}: {}",
                  class_7923.field_41181.method_10221(type),
                  e.getClass().getSimpleName(),
                  e.getLocalizedMessage());
        }
      } else {
        module.logger().warn("{} has no blocks?", class_7923.field_41181.method_10221(type));
      }
    }

    if (Util.isDev()) {
      StringBuilder b = new StringBuilder();
      b.append("Viewable block entities:");
      Main.VIEWABLE_VIEW.forEach((blockEntityType, field) -> {
        b.append('\n')
            .append(class_7923.field_41181.method_10221(blockEntityType))
            .append(": ")
            .append(field.getName());
      });
      module.logger().info(b);
    }
  }
}
