package dev.zenfyr.andromeda.modules.items.pouches.entities;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.common.util.LootContextBuilder;
import dev.zenfyr.andromeda.modules.items.pouches.Main;
import dev.zenfyr.andromeda.modules.items.pouches.items.PouchItem;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import dev.zenfyr.pulsar.util.Utilities;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6067;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PouchEntity extends class_3857 {

  private static final class_2940<Integer> POUCH_TYPE =
      class_2945.method_12791(PouchEntity.class, class_2943.field_13327);

  public PouchEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
    super(entityType, world);
  }

  public PouchEntity(double d, double e, double f, class_1937 world) {
    super(Main.POUCH.orThrow(), d, e, f, world);
  }

  public PouchEntity(class_1309 livingEntity, class_1937 world) {
    super(Main.POUCH.orThrow(), livingEntity, world);
  }

  @Override
  protected void method_7488(class_239 hitResult) {
    class_239.class_240 type = hitResult.method_17783();

    class_1799 stack = method_7495();
    if (type == class_239.class_240.field_1331) {
      this.method_7454((class_3966) hitResult);
      if (field_6002 instanceof class_3218 sw) {
        sw.method_14199(
            new class_2392(class_2398.field_11218, stack),
            method_23317(),
            method_23318(),
            method_23321(),
            10,
            0.2,
            0.2,
            0.2,
            0.25);
      }
      this.method_31472();
    } else if (type == class_239.class_240.field_1332) {
      this.method_24920((class_3965) hitResult);
      if (field_6002 instanceof class_3218 sw) {
        sw.method_14199(
            new class_2392(class_2398.field_11218, stack),
            method_23317(),
            method_23318(),
            method_23321(),
            10,
            0.2,
            0.2,
            0.2,
            0.25);
      }
      this.method_31472();
    }

    if (type != class_239.class_240.field_1333) {
      this.method_32875(class_5712.field_28162, this.method_24921());
    }
  }

  @Override
  protected void method_7454(class_3966 entityHitResult) {
    if (!field_6002.method_8608()) {
      var stacks = LootContextBuilder.prepareLoot(field_6002, this.getPouchType().getLootId(method_7495()));

      class_1297 entity = entityHitResult.method_17782();
      if (entity instanceof class_1657 pe) {
        stacks.forEach(stack -> pe.method_31548().method_7398(stack));
        return;
      } else if (entity instanceof class_6067 io) {
        var storage = InventoryStorage.of(io.method_35199(), null);
        stacks.forEach(stack -> Main.tryInsertItem(field_6002, this.method_19538(), stack, storage));
        return;
      } else if (entity instanceof class_1263 inv) {
        var storage = InventoryStorage.of(inv, null);
        stacks.forEach(stack -> Main.tryInsertItem(field_6002, this.method_19538(), stack, storage));
        return;
      }
      stacks.forEach(stack -> ItemStackUtil.spawnVelocity(
          this.method_19538(), stack, field_6002, -0.2, 0.2, 0.1, 0.2, -0.2, 0.2));
    }
  }

  @Override
  protected void method_24920(class_3965 blockHitResult) {
    if (!field_6002.method_8608()) {
      var stacks = LootContextBuilder.prepareLoot(field_6002, this.getPouchType().getLootId(method_7495()));

      var be = field_6002.method_8321(blockHitResult.method_17777());
      if ((be != null && Main.getViewCount(be) > 0)) {
        var storage = ItemStorage.SIDED.find(
            field_6002,
            blockHitResult.method_17777(),
            field_6002.method_8320(blockHitResult.method_17777()),
            be,
            blockHitResult.method_17780());
        if (storage != null) {
          stacks.forEach(stack -> Main.tryInsertItem(field_6002, this.method_19538(), stack, storage));
          return;
        }
      }
      stacks.forEach(stack -> ItemStackUtil.spawnVelocity(
          this.method_19538(), stack, field_6002, -0.2, 0.2, 0.1, 0.2, -0.2, 0.2));
    }
  }

  @Override
  protected void method_5693() {
    super.method_5693();
    this.field_6011.method_12784(POUCH_TYPE, Type.SEED.syncId);
  }

  @Override
  protected PouchItem method_16942() {
    return getPouchType().getDefaultItem();
  }

  public Type getPouchType() {
    return Type.getType(this.field_6011.method_12789(POUCH_TYPE));
  }

  public void setPouchType(Type type) {
    this.field_6011.method_12778(POUCH_TYPE, type.syncId);
  }

  @Override
  public void method_5652(class_2487 nbt) {
    nbt.method_10582("Type", getPouchType().name());
  }

  @Override
  public void method_5749(class_2487 nbt) {
    if (nbt.method_10545("Type")) {
      setPouchType(Type.valueOf(nbt.method_10558("Type")));
    }
  }

  public enum Type {
    SEED(0, Andromeda.id("pouches/seeds"), Main.SEED_POUCH),
    SAPLING(1, Andromeda.id("pouches/saplings"), Main.SAPLING_POUCH),
    FLOWER(2, Andromeda.id("pouches/flowers"), Main.FLOWER_POUCH),
    CUSTOM(3, null, Main.SPECIAL_POUCH) {
      @Override
      public @NotNull class_2960 getLootId(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545("CustomLootId")) {
          return new class_2960(nbt.method_10558("CustomLootId"));
        }
        return SEED.getLootId(stack);
      }
    };

    private static final Int2ObjectMap<Type> LOOKUP = Utilities.supply(() -> {
      Int2ObjectMap<Type> map = new Int2ObjectOpenHashMap<>();
      for (Type value : Type.values()) {
        map.put(value.syncId, value);
      }
      return map;
    });

    private final int syncId;

    @Nullable private final class_2960 lootId;

    private final Keeper<PouchItem> defaultItem;

    Type(int syncId, @Nullable class_2960 lootId, Keeper<PouchItem> defaultItem) {
      this.syncId = syncId;
      this.lootId = lootId;
      this.defaultItem = defaultItem;
    }

    public @NotNull class_2960 getLootId(class_1799 stack) {
      return Objects.requireNonNull(lootId);
    }

    public PouchItem getDefaultItem() {
      return defaultItem.orThrow();
    }

    public static Type getType(int syncId) {
      return LOOKUP.get(syncId);
    }
  }
}
