package dev.zenfyr.andromeda.modules.items.pouches.items;

import dev.zenfyr.andromeda.common.util.LootContextBuilder;
import dev.zenfyr.andromeda.modules.items.pouches.Main;
import dev.zenfyr.andromeda.modules.items.pouches.entities.PouchEntity;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_6067;
import org.jetbrains.annotations.Nullable;

public class PouchItem extends class_1792 {
  private final PouchEntity.Type type;

  public PouchItem(PouchEntity.Type type, class_1793 settings) {
    super(settings);
    this.type = type;
  }

  @Override
  public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
    if (context.method_8035() && Util.isDev()) {
      tooltip.add(TextUtil.literal("Loot: " + this.getType().getLootId(stack)).method_27692(class_124.field_1080));
    }
  }

  @Override
  public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
    class_1799 itemStack = user.method_5998(hand);
    world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5F, 0.4F / (world.field_9229.method_43057() * 0.4F + 0.8F));
    if (!world.field_9236) {
      var entity = new PouchEntity(user, world);
      entity.setPouchType(this.type);
      entity.method_23327(user.method_23317(), user.method_23320() - 0.1F, user.method_23321());
      entity.method_24919(user, user.method_36455(), user.method_36454(), 0.0F, 1.5F, 1.0F);
      entity.method_16940(itemStack);
      world.method_8649(entity);
    }
    user.method_7259(class_3468.field_15372.method_14956(this));
    if (!user.method_31549().field_7477) {
      itemStack.method_7934(1);
    }
    return class_1271.method_29237(itemStack, world.method_8608());
  }

  @Override
  public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
    if (!user.method_37908().method_8608()) {
      var stacks = LootContextBuilder.prepareLoot(user.method_37908(), type.getLootId(stack));
      boolean success = false;
      if (entity instanceof class_1657 player) {
        var storage = PlayerInventoryStorage.of(player);
        stacks.forEach(itemStack -> Main.tryInsertItem(user.method_37908(), player.method_19538(), itemStack, storage));
        success = true;
      } else if (entity instanceof class_6067 io) {
        var storage = InventoryStorage.of(io.method_35199(), null);
        stacks.forEach(itemStack -> Main.tryInsertItem(entity.method_37908(), entity.method_19538(), itemStack, storage));
        success = true;
      }
      if (success) {
        if (user.method_37908() instanceof class_3218 sw) {
          sw.method_14199(new class_2392(class_2398.field_11218, stack), entity.method_23317(), entity.method_23318(), entity.method_23321(), 10, 0.2, 0.2, 0.2, 0.25);
        }
        if (!user.method_31549().field_7477) {
          stack.method_7934(1);
        }
        return class_1269.field_5812;
      }
    }
    return class_1269.field_5811;
  }

  public PouchEntity.Type getType() {
    return this.type;
  }
}
