package dev.zenfyr.andromeda.modules.items.tooltips.mixin.compass;

import dev.zenfyr.andromeda.common.client.AndromedaClient;
import dev.zenfyr.andromeda.common.util.MiscUtil;
import dev.zenfyr.andromeda.modules.items.tooltips.Tooltips;
import dev.zenfyr.pulsar.util.MathUtil;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1792.class)
abstract class ItemMixin {

  @Inject(at = @At("HEAD"), method = "appendHoverText")
  public void andromeda$tooltip(
      class_1799 stack,
      @Nullable class_1937 world,
      List<class_2561> tooltip,
      class_1836 context,
      CallbackInfo ci) {
    if (!AndromedaClient.CLIENT.get(Tooltips.CONFIG).compass) return;

    if (world != null)
      if (world.field_9236) {
        var player = class_310.method_1551().field_1724;
        if (stack.method_7909() == class_1802.field_8251 && player != null) {
          boolean lodestone = stack.method_7985() && class_1759.method_26365(stack);
          class_4208 globalPos = lodestone
              ? class_1759.method_43124(stack.method_7969())
              : class_1759.method_43123(world);

          double dist;
          if (globalPos != null && world.method_27983() == globalPos.method_19442()) {
            class_243 compassPos = new class_243(
                globalPos.method_19446().method_10263() + 0.5,
                globalPos.method_19446().method_10264() + 0.5,
                globalPos.method_19446().method_10260() + 0.5);
            dist = MiscUtil.horizontalDistanceTo(player.method_19538(), compassPos);
          } else {
            dist = MathUtil.threadRandom().nextGaussian() * 0.1;
          }
          tooltip.add(TextUtil.translatable(
                  lodestone ? "tooltip.andromeda.compass.lodestone" : "tooltip.andromeda.compass",
                  String.format("%.1f", dist))
              .method_27692(class_124.field_1080));
        }
      }
  }
}
