package dev.zenfyr.andromeda.modules.mechanics.dragon_fight;

import static dev.zenfyr.andromeda.common.Andromeda.id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.*;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.apache.commons.lang3.mutable.MutableInt;

@SuppressWarnings("UnstableApiUsage")
public class EnderDragonManager {
  public static final Codec<EnderDragonManager> CODEC = RecordCodecBuilder.create(data -> data.group(Codec.INT.fieldOf("maxPlayers").forGetter(EnderDragonManager::getMaxPlayers), Crystal.CODEC.listOf().fieldOf("crystals").forGetter(EnderDragonManager::getCrystals)).apply(data, EnderDragonManager::new));
  public static final Keeper<AttachmentType<EnderDragonManager>> ATTACHMENT = Keeper.create();
  private final List<Crystal> crystals;
  private int maxPlayers;

  public EnderDragonManager(int maxPlayers, List<Crystal> crystals) {
    this.crystals = new ArrayList<>(crystals);
    this.maxPlayers = Math.max(maxPlayers, 1);
  }

  public void tick(class_3218 world) {
    List<? extends class_1510> dragons = world.method_18776();
    if (dragons.isEmpty()) {
      maxPlayers = 1;
      return;
    }
    int i = Math.max(world.method_18456().size(), 1);
    if (i > maxPlayers) maxPlayers = i;
    Set<Crystal> removal = new HashSet<>();
    for (Crystal pair : crystals) {
      if (pair.timer().decrementAndGet() > 0) continue;
      class_1538 lightning = new class_1538(class_1299.field_6112, world);
      lightning.method_29498(true);
      lightning.method_23327(pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350);
      world.method_8649(lightning);
      class_2675 particleS2CPacket = new class_2675(class_2398.field_11207, true, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350, 0.5F, 0.5F, 0.5F, 0.5F, 100);
      for (int j = 0; j < world.method_18456().size(); ++j) {
        class_3222 serverPlayerEntity = world.method_18456().get(j);
        world.method_14191(serverPlayerEntity, true, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350, particleS2CPacket);
      }
      class_1511 endCrystalEntity = new class_1511(world, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350);
      world.method_8649(endCrystalEntity);
      removal.add(pair);
    }
    crystals.removeAll(removal);
    if (!Andromeda.MAIN.get(DragonFight.CONFIG).scaleHealthByMaxPlayers) return;
    for (class_1510 dragon : dragons) {
      class_1324 inst = dragon.method_5996(class_5134.field_23716);
      MakeSure.notNull(inst, "Ender Dragon has no attributes?").method_6192(Math.floor(Math.sqrt(500 * maxPlayers) * 10));
    }
  }

  public void queueRespawn(MutableInt mutableInt, class_243 vec3d) {
    var crystal = new Crystal(mutableInt, vec3d);
    if (!crystals.contains(crystal)) crystals.add(crystal);
  }


  public record Crystal(MutableInt timer, class_243 pos) {
    public static final Codec<Crystal> CODEC = RecordCodecBuilder.create(data -> data.group(Codec.INT.fieldOf("timer").xmap(MutableInt::new, MutableInt::getValue).forGetter(Crystal::timer), class_243.field_38277.fieldOf("pos").forGetter(Crystal::pos)).apply(data, Crystal::new));
  }

  static void init() {
    EnderDragonManager.ATTACHMENT.init(AttachmentRegistry.<EnderDragonManager>builder().initializer(() -> new EnderDragonManager(1, Collections.emptyList())).persistent(EnderDragonManager.CODEC).buildAndRegister(id("ender_dragon_data")));
    ServerWorldEvents.LOAD.register((server, world) -> {
      if (world.method_27983() == class_1937.field_25181) world.getAttachedOrCreate(EnderDragonManager.ATTACHMENT.get());
    });
    ServerTickEvents.END_WORLD_TICK.register(world -> {
      if (world.method_27983() == class_1937.field_25181) world.getAttachedOrCreate(EnderDragonManager.ATTACHMENT.get()).tick(world);
    });
  }

  public List<Crystal> getCrystals() {
    return this.crystals;
  }

  public int getMaxPlayers() {
    return this.maxPlayers;
  }
}
