package dev.zenfyr.andromeda.modules.mechanics.linkart;

import net.minecraft.class_1269;
import net.minecraft.class_1688;
import net.minecraft.class_1799;

public record CartOperation(Type type, class_1688 minecart) {

  public enum Type {
    LINKING {
      @Override
      public class_1269 perform(
          class_1688 minecart, CartOperation operation, class_1799 stack) {
        if (((LinkableMinecart) minecart).linkart$getFollower() == operation.minecart())
          return class_1269.field_5814; // Linking a parent cart to its follower.
        if (((LinkableMinecart) minecart).linkart$getFollowing() != null)
          return class_1269.field_5814; // Linking to an already linked cart.

        var cfg = minecart.method_37908().am$get(Linkart.CONFIG);
        if (Math.abs(minecart.method_5739(operation.minecart()) - 1) > cfg.pathfindingDistance)
          return class_1269
              .field_5814; // Linking beyond pathfindingDistance, will just break on first tick.

        // Leading minecarts must never be linked to a follower. This creates an immovable object or
        // an Ouroboros, if you will.
        if (((LinkableMinecart) minecart).linkart$getFollower() != null
            && ((LinkableMinecart) minecart).linkart$getFollowing() == null) {
          var temp = minecart;
          while (temp != null) {
            if (temp == operation.minecart()) return class_1269.field_5814;
            temp = ((LinkableMinecart) temp).linkart$getFollower();
          }
        }

        Main.linkTo(minecart, operation.minecart(), stack);
        return class_1269.field_5812;
      }
    },
    UNLINKING {
      @Override
      public class_1269 perform(
          class_1688 minecart, CartOperation operation, class_1799 stack) {
        if (((LinkableMinecart) operation.minecart()).linkart$getFollower() != minecart)
          return class_1269.field_5814;

        Main.unlinkFromParent(minecart);
        return class_1269.field_5812;
      }
    };

    public abstract class_1269 perform(
        class_1688 minecart, CartOperation operation, class_1799 stack);
  }
}
