package dev.zenfyr.andromeda.modules.mechanics.linkart;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

public class LoadingCarts {

  public static final Codec<LoadingCarts> CODEC =
      RecordCodecBuilder.create(data -> data.group(class_2338.field_25064
              .listOf()
              .xmap(Set::copyOf, List::copyOf)
              .fieldOf("reloads")
              .forGetter(o -> {
                Set<class_2338> posSet = new HashSet<>();
                for (class_1688 cart : o.carts) {
                  if (!cart.method_31481()) posSet.add(cart.method_24515());
                }
                return posSet;
              }))
          .apply(data, LoadingCarts::new));

  public static LoadingCarts get(class_1937 level) {
    return ((class_3218) level).getAttachedOrCreate(Main.ATTACHMENT.get());
  }

  private final Set<class_1688> carts = new HashSet<>();
  private final Set<class_2338> reloads = new HashSet<>();

  public LoadingCarts(Set<class_2338> reloads) {
    this.reloads.addAll(reloads);
  }

  public void tick(class_3218 level) {
    if (!this.reloads.isEmpty()) {
      for (class_2338 reload : this.reloads) {
        level.method_14178().method_17297(class_3230.field_19280, new class_1923(reload), 4, reload);
      }
      this.reloads.clear();
    }
  }

  public void addCart(class_1688 cart) {
    this.carts.add(cart);
  }

  public void removeCart(class_1688 cart) {
    this.carts.remove(cart);
  }
}
