package dev.zenfyr.andromeda.modules.mechanics.linkart;

import static dev.zenfyr.andromeda.common.Andromeda.id;

import dev.zenfyr.andromeda.common.util.Keeper;
import java.util.Set;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class Main {

  public static final class_6862<class_1792> LINKERS =
      class_6862.method_40092(class_7923.field_41178.method_30517(), id("linkers"));
  public static final Keeper<AttachmentType<LoadingCarts>> ATTACHMENT = Keeper.create();

  public static void init() {
    ATTACHMENT.init(AttachmentRegistry.<LoadingCarts>builder()
        .initializer(() -> new LoadingCarts(Set.of()))
        .persistent(LoadingCarts.CODEC)
        .buildAndRegister(id("loading_carts")));

    ServerTickEvents.START_WORLD_TICK.register(level -> {
      var cfg = level.am$get(Linkart.CONFIG);
      if (cfg.chunkloading) {
        level.getAttachedOrCreate(ATTACHMENT.get()).tick(level);
      }
    });
  }

  public static boolean shouldCollide(class_1297 source, class_1297 target) {
    if (source instanceof class_1688 check) {
      int i = 0;

      do {
        if (check == target) {
          return false;
        }

        check = ((LinkableMinecart) check).linkart$getFollower();
        ++i;
      } while (check != null && i < 8);

      check = (class_1688) source;
      i = 0;

      while (check != target) {
        check = ((LinkableMinecart) check).linkart$getFollowing();
        ++i;
        if (check == null || i >= 8) {
          return true;
        }
      }

      return false;
    }
    return true;
  }

  public static void spawnChainParticles(class_1688 entity) {
    if (!entity.method_37908().method_8608()) {
      ((class_3218) entity.method_37908())
          .method_14199(
              new class_2392(
                  class_2398.field_11218, ((LinkableMinecart) entity).linkart$getLinkItem()),
              entity.method_23317(),
              entity.method_23318() + 0.3,
              entity.method_23321(),
              15,
              0.2,
              0.2,
              0.2,
              0.2);
    }
  }

  public static boolean approximatelyZero(double a) {
    return Math.abs(0 - a) < 0.00029146489604938;
  }

  public static void unlinkFromParent(class_1688 entity) {
    if (entity == null) return;
    var following = ((LinkableMinecart) entity).linkart$getFollowing();
    if (following == null) return;

    ((LinkableMinecart) following).linkart$setFollower(null);
    ((LinkableMinecart) entity).linkart$setFollowing(null);

    entity.method_18800(0, 0, 0);

    if (!((LinkableMinecart) entity).linkart$getLinkItem().method_7960()) {
      entity.method_5775(((LinkableMinecart) entity).linkart$getLinkItem());
      spawnChainParticles(entity);
    }

    ((LinkableMinecart) entity).linkart$setLinkItem(class_1799.field_8037);
  }

  public static void linkTo(class_1688 minecart, class_1688 to, class_1799 linkingItem) {
    ((LinkableMinecart) minecart).linkart$setFollowing(to);
    ((LinkableMinecart) to).linkart$setFollower(minecart);

    if (!linkingItem.method_7960()) {
      class_1799 linkStack = linkingItem.method_7972();
      linkStack.method_7939(1);
      ((LinkableMinecart) minecart).linkart$setLinkItem(linkStack);
    }

    Main.spawnChainParticles(minecart);
  }
}
