package dev.zenfyr.andromeda.modules.mechanics.linkart.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.zenfyr.andromeda.modules.mechanics.linkart.LinkableMinecart;
import dev.zenfyr.andromeda.modules.mechanics.linkart.Linkart;
import dev.zenfyr.andromeda.modules.mechanics.linkart.LoadingCarts;
import dev.zenfyr.andromeda.modules.mechanics.linkart.Main;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1688.class)
public abstract class AbstractMinecartEntityMixin extends class_1297 implements LinkableMinecart {

  // Used to smooth out acceleration
  @Unique private static final double SAFE_SPEEDUP_THRESHOLD = 0.4;

  @Unique private static final double SMOOTH_SPEEDUP_AMOUNT = 0.2;

  @Unique private static final double SAFE_SPEEDUP_DIFFERENCE = 0.02;

  @Unique private double lastMovementLength = 0.0D; // Movement length on previous tick

  @Unique private class_1688 linkart$following;

  @Unique private class_1688 linkart$follower;

  @Unique private UUID linkart$followingUUID;

  @Unique private UUID linkart$followerUUID;

  @Unique private class_1799 linkart$itemStack = class_1799.field_8037;

  public AbstractMinecartEntityMixin(class_1299<?> type, class_1937 world) {
    super(type, world);
  }

  @Unique private double limitMovementLength(double targetMovementLength) {
    double cartLastMovementLength = this.lastMovementLength;

    boolean isLeading = (this.linkart$getFollowing() == null && this.linkart$getFollower() != null);
    // Don't limit if we are not the leading minecart
    if (!isLeading) return targetMovementLength;
    // Don't limit if we are below the safe speedup threshold
    if (targetMovementLength <= SAFE_SPEEDUP_THRESHOLD) return targetMovementLength;

    class_1688 follower = this.linkart$getFollower();
    // Check if there are follower minecarts not at our speed
    while (follower != null) {
      double followerLastMovementLength =
          ((AbstractMinecartEntityMixin) (Object) follower).lastMovementLength;
      if (Math.abs(followerLastMovementLength - cartLastMovementLength) > SAFE_SPEEDUP_DIFFERENCE)
        // If so, maintain same speed
        return cartLastMovementLength;
      follower = ((LinkableMinecart) follower).linkart$getFollower();
    }

    // Otherwise increase our speed slowly
    return Math.min(
        Math.max(cartLastMovementLength + SMOOTH_SPEEDUP_AMOUNT, SAFE_SPEEDUP_THRESHOLD), // min
        targetMovementLength); // max
  }

  // Ensure the train doesn't break apart (especially if other minecart mods increase speed)
  @ModifyArg(
      method = "moveAlongTrack",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V",
              ordinal = 0))
  private class_243 modifiedMovement(class_243 movement) {
    if (this.lastMovementLength < movement.method_1033()) {
      final double targetMovementLength = movement.method_1033();

      // Limit the movement length
      movement = movement.method_1021(limitMovementLength(targetMovementLength) / targetMovementLength);
    }

    this.lastMovementLength = movement.method_1033();
    return movement;
  }

  @WrapOperation(
      method = "moveAlongTrack",
      at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Mth;clamp(DDD)D"))
  private double linkart$skipVelocityClamping(
      double value, double min, double max, Operation<Double> original) {
    if (this.linkart$getFollowing() != null) {
      class_1688 following = this.linkart$getFollowing();
      while (((LinkableMinecart) following).linkart$getFollowing() != null) {
        following = ((LinkableMinecart) following).linkart$getFollowing();
      }
      double parent = following.method_7504();
      return class_3532.method_15350(value, -parent, parent);
    }
    return original.call(value, min, max);
  }

  @Inject(at = @At("HEAD"), method = "tick")
  private void linkart$tick(CallbackInfo ci) {
    if (method_37908().method_8608()) return;
    class_1688 cast = (class_1688) (Object) this;
    if (linkart$getFollowing() == null) return;
    var cfg = method_37908().am$get(Linkart.CONFIG);

    class_243 pos = method_19538();
    class_243 pos2 = linkart$getFollowing().method_19538();
    double dist = Math.max(Math.abs(pos.method_1022(pos2)) - cfg.distance, 0);
    class_243 vec3d = pos.method_1035(pos2);
    vec3d = vec3d.method_1021(cfg.velocityMultiplier);

    // Check if we are on a sharp curve
    class_243 vel = method_18798();
    class_243 vel2 = linkart$getFollowing().method_18798();
    boolean differentDirection = (vel.method_1033() > 0.15
        && vel2.method_1033() > 0.005
        && vel.method_1029().method_1022(vel2.method_1029()) > 1.42
        && pos.method_1022(pos2) > 0.5);

    if (differentDirection) {
      // Keep ourselves going at same speed if on curve
      dist += cfg.distance;
      vec3d = vel;
    }

    // Calculate new velocity
    vec3d = vec3d.method_1029().method_1021(dist);

    if (dist <= 1) {
      // Go slower (1.0->0.8) the closer (1->0) we are
      method_18799(vec3d.method_1021(0.8 + 0.2 * Math.abs(dist)));
    } else if (dist <= cfg.pathfindingDistance) {
      method_18799(vec3d);
    } else {
      Main.unlinkFromParent(cast);
    }

    if (cfg.chunkloading) {
      if (linkart$getFollower() != null
          && !Main.approximatelyZero(this.method_18798().method_1033())) {
        ((class_3218) this.method_37908())
            .method_14178()
            .method_17297(
                class_3230.field_19280,
                this.method_31476(),
                cfg.chunkloadingRadius,
                this.method_24515());
        LoadingCarts.get(method_37908()).addCart(cast);
      } else {
        LoadingCarts.get(method_37908()).removeCart(cast);
      }
    }
  }

  @Inject(at = @At("HEAD"), method = "push", cancellable = true)
  void onPushAway(class_1297 entity, CallbackInfo ci) {
    if (!Main.shouldCollide(this, entity)) ci.cancel();
  }

  @Inject(at = @At("RETURN"), method = "addAdditionalSaveData")
  private void linkart$write(class_2487 nbt, CallbackInfo ci) {
    if (linkart$followingUUID != null) nbt.method_25927("LK-Following", linkart$followingUUID);
    if (linkart$followerUUID != null) nbt.method_25927("LK-Follower", linkart$followerUUID);
    if (linkart$itemStack != null)
      nbt.method_10566("LK-ItemStack", linkart$itemStack.method_7953(new class_2487()));
  }

  @Inject(at = @At("RETURN"), method = "readAdditionalSaveData")
  private void linkart$read(class_2487 nbt, CallbackInfo ci) {
    if (nbt.method_10545("LK-Following")) linkart$followingUUID = nbt.method_25926("LK-Following");
    if (nbt.method_10545("LK-Follower")) linkart$followerUUID = nbt.method_25926("LK-Follower");
    if (nbt.method_10545("LK-ItemStack"))
      linkart$itemStack = class_1799.method_7915(nbt.method_10562("LK-ItemStack"));
  }

  @Override
  public class_1688 linkart$getFollowing() {
    if (linkart$following == null && linkart$followingUUID != null) {
      linkart$following =
          (class_1688) ((class_3218) this.method_37908()).method_14190(linkart$followingUUID);
    }
    return linkart$following;
  }

  @Override
  public void linkart$setFollowing(class_1688 following) {
    this.linkart$following = following;
    this.linkart$followingUUID = following != null ? following.method_5667() : null;
  }

  @Override
  public class_1688 linkart$getFollower() {
    if (linkart$follower == null && linkart$followerUUID != null) {
      linkart$follower =
          (class_1688) ((class_3218) this.method_37908()).method_14190(linkart$followerUUID);
    }
    return linkart$follower;
  }

  @Override
  public void linkart$setFollower(class_1688 follower) {
    this.linkart$follower = follower;
    this.linkart$followerUUID = follower != null ? follower.method_5667() : null;
  }

  @Override
  public class_1799 linkart$getLinkItem() {
    return linkart$itemStack;
  }

  @Override
  public void linkart$setLinkItem(class_1799 linkItem) {
    this.linkart$itemStack = linkItem == null ? class_1799.field_8037 : linkItem;
  }
}
