package dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation;

import com.google.gson.JsonElement;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_163;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5258;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class Main {
  private static final Map<class_3956<?>, Function<Context, Return>> RECIPE_TYPE_HANDLERS =
      new HashMap<>();
  private static final List<BiPredicate<class_2960, class_1860<?>>> FILTERS =
      Collections.synchronizedList(new ArrayList<>());

  public static Function<Context, Return> basicConsumer(
      String typeName, AdvancementGeneration.Config config) {
    return context -> new Return(
        idFromRecipe(context.id(), typeName),
        createAdvBuilder(config, context.id(), context.recipe().method_8117().get(0)));
  }

  private static class_2960 idFromRecipe(class_2960 recipe, String typeName) {
    return new class_2960(
        recipe.method_12836(),
        "recipes/gen/" + typeName + "/" + recipe.toString().replace(":", "_"));
  }

  public static void addRecipeTypeHandler(class_3956<?> type, Function<Context, Return> consumer) {
    RECIPE_TYPE_HANDLERS.putIfAbsent(type, consumer);
  }

  public static void generateRecipeAdvancements(
      MinecraftServer server, AdvancementGeneration module, AdvancementGeneration.Config config) {
    Map<class_2960, class_161.class_162> advancementBuilders = new ConcurrentHashMap<>();
    AtomicInteger count = new AtomicInteger();

    List<CompletableFuture<Void>> futures = server.method_3772().method_8126().stream()
        .filter(recipe -> {
          for (BiPredicate<class_2960, class_1860<?>> filter : FILTERS) {
            if (filter.test(recipe.method_8114(), recipe)) return false;
          }
          return true;
        })
        .map(recipe -> CompletableFuture.runAsync(
            () -> {
              var handler = RECIPE_TYPE_HANDLERS.get(recipe.method_17716());
              if (handler != null) {
                count.getAndIncrement();
                var r = handler.apply(new Context(recipe, recipe.method_8114()));
                if (r != null) advancementBuilders.put(r.id(), r.builder());
              } else {
                if (!recipe.method_8117().isEmpty()) {
                  count.getAndIncrement();
                  advancementBuilders.put(
                      new class_2960(
                          recipe.method_8114().method_12836(),
                          "recipes/gen/generic/" + recipe.method_8114().toString().replace(":", "_")),
                      createAdvBuilder(
                          config,
                          recipe.method_8114(),
                          recipe.method_8117().toArray(class_1856[]::new)));
                }
              }
            },
            class_156.method_18349()))
        .toList();
    // and?
    CompletableFuture<Void> future =
        CompletableFuture.allOf(futures.toArray(CompletableFuture[]::new));
    server.method_18857(future::isDone);

    class_163 advancementManager = server.method_3851().field_13404;
    advancementManager.method_711(advancementBuilders);

    module.logger().info("finished generating {} recipe advancements", count.get());
    advancementBuilders.clear();
  }

  static final class CustomPredicate extends class_2073 {
    private final class_1856 ingredient;

    CustomPredicate(class_1856 ingredient) {
      this.ingredient = ingredient;
    }

    @Override
    public boolean method_8970(class_1799 stack) {
      return ingredient.method_8093(stack);
    }

    @Override
    public JsonElement method_8971() {
      return field_9640.method_8971();
    }
  }

  public static @NotNull class_161.class_162 createAdvBuilder(
      AdvancementGeneration.Config config, class_2960 id, class_1856... ingredients) {
    MakeSure.notEmpty(ingredients); // shouldn't really happen
    var builder = class_161.class_162.method_51698();
    builder.method_708(class_2960.method_43902("minecraft", "recipes/root"));

    List<String> names = new ArrayList<>();
    Set<JsonElement> elements = new HashSet<>();
    for (int i = 0; i < ingredients.length; i++) {
      var ingredient = ingredients[i];

      if (ingredient.method_8103()) continue;
      if (!elements.add(ingredient.method_8089())) continue;

      var name = String.valueOf(i);
      names.add(name);
      builder.method_709(
          name, class_2066.class_2068.method_8957(new CustomPredicate(ingredient)));
    }
    builder.method_709(
        "has_recipe",
        new class_2119.class_2121(class_5258.method_27973(), id));

    String[][] reqs;
    if (config.requireAllItems) {
      reqs = new String[names.size()][2];
      for (int i = 0; i < names.size(); i++) {
        String s = names.get(i);
        reqs[i][0] = s;
        reqs[i][1] = "has_recipe";
      }
    } else {
      reqs = new String[1][names.size() + 1];
      for (int i = 0; i < names.size(); i++) {
        String s = names.get(i);
        reqs[0][i] = s;
      }
      reqs[0][names.size()] = "has_recipe";
    }
    builder.method_34884(reqs);

    Optional.ofNullable(class_170.class_171.method_753(id).method_751()).ifPresent(builder::method_706);
    return builder;
  }

  static void init(AdvancementGeneration module, AdvancementGeneration.Config config) {
    FILTERS.add((id, recipe) -> config.namespaceBlacklist.contains(id.method_12836()));
    FILTERS.add((id, recipe) -> config.recipeBlacklist.contains(id));
    FILTERS.add((id, recipe) -> recipe.method_8118() && config.ignoreRecipesHiddenInTheRecipeBook);

    ServerLifecycleEvents.SERVER_STARTING.register(
        server -> generateRecipeAdvancements(server, module, config));
    BeforeDataPackSyncEvent.EVENT.register(
        server -> generateRecipeAdvancements(server, module, config));

    addRecipeTypeHandler(class_3956.field_17547, basicConsumer("blasting", config));
    addRecipeTypeHandler(class_3956.field_17548, basicConsumer("smoking", config));
    addRecipeTypeHandler(class_3956.field_17546, basicConsumer("smelting", config));
    addRecipeTypeHandler(class_3956.field_17549, basicConsumer("campfire_cooking", config));
    addRecipeTypeHandler(class_3956.field_17641, basicConsumer("stonecutting", config));
    addRecipeTypeHandler(class_3956.field_17545, (context) -> {
      if (!(context.recipe() instanceof class_1852)) {
        if (!context.recipe().method_8117().isEmpty()) {
          return new Return(
              idFromRecipe(context.id(), "crafting"),
              createAdvBuilder(
                  config,
                  context.id(),
                  context.recipe().method_8117().toArray(class_1856[]::new)));
        }
      }
      return null;
    });
  }

  public record Return(class_2960 id, class_161.class_162 builder) {}

  public record Context(class_1860<?> recipe, class_2960 id) {}
}
