package dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation.mixin;

import dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation.BeforeDataPackSyncEvent;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
abstract class PlayerManagerMixin {

  @Shadow
  @Final
  private MinecraftServer server;

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target = "Ljava/util/Map;values()Ljava/util/Collection;",
              ordinal = 0,
              shift = At.Shift.BEFORE),
      method = "reloadResources")
  private void andromeda$reload(CallbackInfo ci) {
    // we don't sync until our advancements have been generated
    BeforeDataPackSyncEvent.EVENT.invoker().beforeDataPackReload(server);
  }
}
