package dev.zenfyr.andromeda.modules.misc.tiny_storage.mixin;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.modules.misc.tiny_storage.TinyStorage;
import dev.zenfyr.pulsar.nbt.NbtUtil;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
abstract class PlayerEntityMixin {

  @Shadow
  @Final
  public class_1723 inventoryMenu;

  @Shadow
  @Nullable public abstract class_1542 drop(class_1799 stack, boolean throwRandomly, boolean retainOwnership);

  @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
  private void andromeda$writeNbt(class_2487 nbt, CallbackInfo ci) {
    NbtUtil.writeInventoryToTag("AM-Tiny-Storage", nbt, this.inventoryMenu.method_29281());
  }

  @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
  private void andromeda$readNbt(class_2487 nbt, CallbackInfo ci) {
    try {
      TinyStorage.LOADING.set(true); // We have to skip sending handler updates.
      NbtUtil.readInventoryFromTag("AM-Tiny-Storage", nbt, this.inventoryMenu.method_29281());
    } finally {
      TinyStorage.LOADING.remove();
    }
  }

  @Inject(
      at =
          @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Inventory;dropAll()V"),
      method = "dropEquipment")
  private void andromeda$dropAll(CallbackInfo ci) {
    if (Andromeda.MAIN.get(TinyStorage.CONFIG).transferMode
        == TinyStorage.TransferMode.ALWAYS_TRANSFER) return;

    for (int i = 0; i < this.inventoryMenu.method_29281().method_5439(); ++i) {
      class_1799 stack = this.inventoryMenu.method_29281().method_5441(i);
      if (!stack.method_7960() && class_1890.method_8221(stack)) continue;
      this.drop(stack, true, false);
    }
  }
}
