package dev.zenfyr.andromeda.modules.world.falling_beenests;

import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.pulsar.nbt.CompoundTagBuilder;
import java.util.List;
import lombok.NonNull;
import net.minecraft.class_1540;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4482;
import net.minecraft.class_8567;

public class BeeUtil {
  public static final List<class_2350> AROUND_BLOCK_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034);
  public static final class_2960 BEE_LOOT_ID = Andromeda.id("bee_nest/bee_nest_broken");

  public static List<class_1799> prepareLoot(@NonNull class_1937 world, @NonNull class_2960 lootId) {
    if (world == null) {
      throw new NullPointerException("world is marked non-null but is null");
    }
    if (lootId == null) {
      throw new NullPointerException("lootId is marked non-null but is null");
    }
    return ((class_3218) world).method_8503().method_3857().getLootTable(lootId).method_51878(new class_8567.class_8568(((class_3218) world)).method_51875(class_173.field_1175));
  }

  public static void trySpawnFallingBeeNest(@NonNull class_1937 world, @NonNull class_2338 pos, @NonNull class_2680 state, @NonNull class_4482 beehiveBlockEntity) {
    if (world == null) {
      throw new NullPointerException("world is marked non-null but is null");
    }
    if (pos == null) {
      throw new NullPointerException("pos is marked non-null but is null");
    }
    if (state == null) {
      throw new NullPointerException("state is marked non-null but is null");
    }
    if (beehiveBlockEntity == null) {
      throw new NullPointerException("beehiveBlockEntity is marked non-null but is null");
    }
    class_1540 fallingBlock = new class_1540(world, pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5, state.method_28498(class_2741.field_12508) ? state.method_11657(class_2741.field_12508, Boolean.FALSE) : state);
    // Thanks AccessWidener!
    fallingBlock.method_5749(CompoundTagBuilder.create().put("TileEntityData", CompoundTagBuilder.create().put("Bees", beehiveBlockEntity.method_21859()).putBoolean("AM-FromFallenBlock", true).build()).put("BlockState", class_2512.method_10686(state)).build());
    world.method_8652(pos, state.method_26227().method_15759(), class_2248.field_31036);
    world.method_8649(fallingBlock);
  }
}
