package dev.zenfyr.andromeda.modules.world.falling_beenests.mixin;

import dev.zenfyr.andromeda.modules.world.falling_beenests.BeeUtil;
import dev.zenfyr.andromeda.modules.world.falling_beenests.CanBeeNestsFall;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import dev.zenfyr.pulsar.util.PlayerUtil;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4466;
import net.minecraft.class_4482;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1540.class)
abstract class FallingBlockMixin extends class_1297 {

  @Shadow
  @Nullable public class_2487 blockData;

  @Shadow
  private class_2680 blockState;

  public FallingBlockMixin(class_1299<?> type, class_1937 world) {
    super(type, world);
  }

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;",
              shift = At.Shift.AFTER),
      method = "tick")
  public void andromeda$tick(CallbackInfo ci) {
    class_2338 blockPos = this.method_24515();
    class_2586 blockEntity = this.field_6002.method_8321(blockPos);
    if (blockEntity == null) return;

    if (blockEntity instanceof class_4482 beehiveBlockEntity
        && this.field_6002.am$get(CanBeeNestsFall.CONFIG).available) {
      if (this.blockState.method_26204() != class_2246.field_20421) return;
      if (blockData == null || !blockData.method_10577("AM-FromFallenBlock")) return;

      blockData.method_10556("AM-FromFallenBlock", false);

      Optional<class_1657> optional =
          PlayerUtil.findClosestNonCreativePlayerInRange(field_6002, this.method_24515(), 16);
      final class_2499 nbeetlist = blockData.method_10554("Bees", 10);

      field_6002.method_22352(beehiveBlockEntity.method_11016(), false);
      for (int i = 0; i < nbeetlist.size(); ++i) {
        class_2487 entityData = nbeetlist.method_10602(i).method_10562("EntityData");
        class_4482.method_36379(entityData);
        class_4466 bee = class_1299.field_20346.method_5883(field_6002);
        if (bee == null) continue;

        bee.method_5651(entityData);
        bee.method_33574(method_19538());
        bee.method_21807(400);
        optional.ifPresent(bee::method_5980);
        field_6002.method_8649(bee);
      }
      optional.ifPresent(player -> field_6002
          .method_18467(class_4466.class, new class_238(method_24515()).method_1014(50))
          .forEach(bee -> bee.method_5980(player)));

      for (class_1799 stack : BeeUtil.prepareLoot(field_6002, BeeUtil.BEE_LOOT_ID)) {
        ItemStackUtil.spawnVelocity(this.method_19538(), stack, field_6002, -0.3, 0.3, 0.05, 0.2, -0.3, 0.3);
      }
    }
  }
}
