package dev.zenfyr.andromeda.modules.world.loot_barrels;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.zenfyr.andromeda.common.Andromeda;
import java.util.Arrays;
import java.util.Comparator;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3708;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5821;
import net.minecraft.class_6032;
import net.minecraft.class_6796;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class LootBarrelFeature extends class_3031<LootBarrelFeature.LootBarrelConfiguration> {

  private static final class_2350[] HORIZONTAL = Arrays.stream(class_2350.values())
      .filter((direction) -> direction.method_10166().method_10179())
      .sorted(Comparator.comparingInt(class_2350::method_10161))
      .toArray(class_2350[]::new);

  public LootBarrelFeature() {
    super(LootBarrelConfiguration.CODEC);
  }

  @Override
  public boolean method_13151(class_5821<LootBarrelConfiguration> context) {
    var world = context.method_33652();
    if (!world.method_8320(context.method_33655()).method_26215()
        || !world.method_8320(context.method_33655().method_10074()).method_26225()) return false;

    world.method_8652(
        context.method_33655(),
        class_2246.field_16328
            .method_9564()
            .method_11657(class_3708.field_16320, class_156.method_27173(HORIZONTAL, context.method_33654())),
        class_2248.field_31028);
    class_2621.method_11287(
        world, context.method_33654(), context.method_33655(), context.method_33656().loot());

    if (world.method_8320(context.method_33655().method_10084()).method_26215()
        && context.method_33656().decorations().method_35094().findAny().isPresent()) {
      world.method_8652(
          context.method_33655().method_10084(),
          context.method_33656().decorations().method_35088().method_35094().findFirst().orElseThrow(),
          class_2248.field_31028);
    }
    return true;
  }

  public record LootBarrelConfiguration(
      class_2960 loot, class_6032<class_2680> decorations)
      implements class_3037 {

    public static final Codec<LootBarrelConfiguration> CODEC =
        RecordCodecBuilder.create(data -> data.group(
                class_2960.field_25139.fieldOf("loot").forGetter(LootBarrelConfiguration::loot),
                class_6032.method_35091(class_2680.field_24734)
                    .fieldOf("decorations")
                    .forGetter(LootBarrelConfiguration::decorations))
            .apply(data, LootBarrelConfiguration::new));
  }

  public static void init() {
    class_2378.method_10230(
        class_7923.field_41144, Andromeda.id("loot_barrel"), new LootBarrelFeature());

    class_5321<class_6796> key = Andromeda.key(class_7924.field_41245, "loot_barrel");
    BiomeModifications.addFeature(
        context -> context.canGenerateIn(class_5363.field_25412),
        class_2893.class_2895.field_13172,
        key);
  }
}
