package dev.zenfyr.andromeda.modules.world.quick_fire.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.zenfyr.andromeda.modules.world.quick_fire.QuickFire;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2358.class)
abstract class AbstractFireBlockMixin extends class_4770 {

  @Shadow
  protected abstract void checkBurnOut(
      class_1937 world, class_2338 pos, int spreadFactor, class_5819 random, int currentAge);

  @Unique private static final ThreadLocal<Boolean> LOCAL = ThreadLocal.withInitial(() -> Boolean.FALSE);

  public AbstractFireBlockMixin(class_2251 settings, float damage) {
    super(settings, damage);
  }

  @ModifyVariable(method = "checkBurnOut", at = @At("LOAD"), index = 3, argsOnly = true)
  public int andromeda$spreadFire0(
      int value, @Local(argsOnly = true) class_1937 world, @Local(argsOnly = true) class_2338 pos) {
    return Boolean.TRUE.equals(LOCAL.get()) ? (int) (value * 0.8) : value;
  }

  @ModifyExpressionValue(
      method = "checkBurnOut",
      at = @At(value = "CONSTANT", args = "intValue=10"))
  public int andromeda$spreadFire01(int value, @Local(argsOnly = true) class_1937 world) {
    return Boolean.TRUE.equals(LOCAL.get()) ? (int) Math.ceil(value / 3d) : value;
  }

  @Inject(
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/world/level/block/FireBlock;checkBurnOut(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;ILnet/minecraft/util/RandomSource;I)V",
              ordinal = 0,
              shift = At.Shift.BEFORE),
      method = "tick")
  public void andromeda$trySpreadBlocks(
      class_2680 state,
      class_3218 world,
      class_2338 pos,
      class_5819 random,
      CallbackInfo ci,
      @Local(index = 7) int i,
      @Local(index = 10) int k) {
    if (world.am$get(QuickFire.CONFIG).available) {
      try {
        LOCAL.set(Boolean.TRUE);
        for (int x = -3; x < 3; x++) {
          for (int y = -3; y < 3; y++) {
            for (int z = -3; z < 3; z++) {
              this.checkBurnOut(
                  world,
                  new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z),
                  300 + k,
                  random,
                  i);
            }
          }
        }
      } finally {
        LOCAL.remove();
      }
    }
  }
}
