/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap;

import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.ModuleInfo;
import dev.zenfyr.andromeda.bootstrap.event.EventMarker;
import dev.zenfyr.andromeda.bootstrap.event.PostBootstrapEvent;
import dev.zenfyr.andromeda.bootstrap.event.bus.Bus;
import dev.zenfyr.pulsar.util.functions.Memoize;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class Module {
    private final ModuleInfo meta;
    private final Supplier<Logger> logger = Memoize.supplier(() -> LogManager.getLogger((String)ModuleHelper.id(this)));
    private final Map<EventMarker<?>, Bus<?>> busMap = new IdentityHashMap();

    protected Module() {
        this.meta = this.getClass().getAnnotation(ModuleInfo.class);
        Module module = this;
        if (module instanceof PostBootstrapEvent) {
            PostBootstrapEvent pbe = (PostBootstrapEvent)((Object)module);
            PostBootstrapEvent.get(this).listen(pbe);
        }
    }

    public <E> Bus<E> getOrCreateBus(EventMarker<E> id, @Nullable Supplier<Bus<E>> supplier) {
        return this.busMap.computeIfAbsent(id, aClass -> supplier == null ? null : (Bus)supplier.get());
    }

    public void dropBus(EventMarker<?> id) {
        this.busMap.remove(id);
    }

    public Logger logger() {
        return this.logger.get();
    }

    public ModuleInfo meta() {
        return this.meta;
    }
}

