/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap;

import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.config.BootstrapConfig;
import dev.zenfyr.andromeda.bootstrap.config.handler.BootstrapConfigHandler;
import dev.zenfyr.andromeda.bootstrap.config.handler.ModConfigHandler;
import dev.zenfyr.andromeda.bootstrap.event.BootstrapConfigEvent;
import dev.zenfyr.andromeda.bootstrap.event.PostBootstrapEvent;
import dev.zenfyr.andromeda.bootstrap.event.PostModuleInitEvent;
import dev.zenfyr.andromeda.bootstrap.util.Environment;
import dev.zenfyr.andromeda.bootstrap.util.mixin.MixinHandler;
import dev.zenfyr.andromeda.modules.ModuleDiscovery;
import dev.zenfyr.andromeda.util.DataRefreshUtil;
import dev.zenfyr.andromeda.util.Debug;
import dev.zenfyr.andromeda.util.InstanceDataHolder;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.util.Utilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.Logger;

public class ModuleManager
implements PreLaunchEntrypoint {
    @Generated
    private static final Logger log = Util.logger();
    private final ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("andromeda").orElseThrow();
    private final ModConfigHandler modConfig = ModConfigHandler.load();
    private final BootstrapConfigHandler configHandler = new BootstrapConfigHandler();
    private final MixinHandler mixinHandler = new MixinHandler(this);
    private final InstanceDataHolder dataHolder = InstanceDataHolder.load();
    private final Map<Class<?>, Module> discoveredModules = new IdentityHashMap();
    private final Map<String, Module> discoveredModulesByName = new LinkedHashMap<String, Module>();
    private final Map<Class<?>, Module> modules = new IdentityHashMap();
    private final Map<String, Module> modulesByName = new LinkedHashMap<String, Module>();
    private static ModuleManager instance;

    public void onPreLaunch() {
        instance = this;
        this.modConfig.save();
        DataRefreshUtil.initialize(this);
        List<Class> moduleClasses = new ModuleDiscovery().discoverModules().stream().peek(cls -> {
            if (ModuleHelper.getMeta(cls) == null) {
                throw Util.create("%s has no ModuleInfo annotation", IllegalStateException::new);
            }
        }).filter(cls -> {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                return true;
            }
            return ModuleHelper.getMeta(cls).env().allows(Environment.SERVER);
        }).toList();
        for (Class cls2 : moduleClasses) {
            try {
                Constructor<?> ctx = cls2.getDeclaredConstructors()[0];
                ctx.setAccessible(true);
                Module module = (Module)ctx.newInstance(new Object[0]);
                this.discoveredModules.put(cls2, module);
                this.discoveredModulesByName.put(ModuleHelper.id(module), module);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw Util.wrap("Failed to create module %s".formatted(cls2.getName()), e);
            }
        }
        for (Module value : this.discoveredModulesByName.values()) {
            ModuleHelper.runAndDropBus(value, PostModuleInitEvent.ID, PostModuleInitEvent::postModuleInit);
        }
        for (Module value : this.discoveredModulesByName.values()) {
            BootstrapConfig config = this.configHandler.load(value);
            ModuleHelper.runAndDropBus(value, BootstrapConfigEvent.ID, event -> event.bootstrapConfig(config));
            if (config.enabled || Debug.get().enableAllModules) {
                this.modules.put(value.getClass(), value);
                this.modulesByName.put(ModuleHelper.id(value.meta()), value);
            }
            this.configHandler.save(value);
        }
        this.mixinHandler.addMixins();
        this.printModuleStats();
        for (Module value : this.modulesByName.values()) {
            ModuleHelper.runAndDropBus(value, PostBootstrapEvent.ID, PostBootstrapEvent::postBootstrap);
        }
    }

    public <T extends Module> Optional<T> getDiscovered(Class<T> cls) {
        return Optional.ofNullable(this.discoveredModules.get(cls));
    }

    public <T extends Module> Optional<T> getDiscovered(String val) {
        return Optional.ofNullable(this.discoveredModulesByName.get(val));
    }

    public <T extends Module> Optional<T> get(Class<T> cls) {
        return Optional.ofNullable(this.modules.get(cls));
    }

    public <T extends Module> Optional<T> get(String val) {
        return Optional.ofNullable(this.modulesByName.get(val));
    }

    public Collection<Module> loaded() {
        return this.modules.values();
    }

    public Collection<Module> all() {
        return this.discoveredModules.values();
    }

    public static ModuleManager get() {
        return instance;
    }

    private void printModuleStats() {
        Map categories = (Map)Utilities.supply(new LinkedHashMap(), map -> this.loaded().forEach(m -> map.computeIfAbsent(m.meta().category(), s -> new LinkedHashSet()).add(m)));
        StringBuilder builder = new StringBuilder();
        categories.forEach((s, strings) -> {
            builder.append("\n\t - ").append((String)s).append("\n\t  |-- ");
            StringJoiner joiner = new StringJoiner(", ");
            strings.forEach(m -> joiner.add(ModuleHelper.dotted(m)));
            builder.append(joiner);
        });
        if (!categories.isEmpty()) {
            log.info("Loading {} modules: {}", (Object)this.loaded().size(), (Object)builder);
        } else {
            log.info("No modules loaded!");
        }
    }

    @Generated
    public ModContainer modContainer() {
        return this.modContainer;
    }

    @Generated
    public ModConfigHandler modConfig() {
        return this.modConfig;
    }

    @Generated
    public BootstrapConfigHandler configHandler() {
        return this.configHandler;
    }

    @Generated
    public MixinHandler mixinHandler() {
        return this.mixinHandler;
    }

    @Generated
    public InstanceDataHolder dataHolder() {
        return this.dataHolder;
    }
}

