/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public abstract class BaseConfig {
    private static final Map<Class<? extends BaseConfig>, Set<Field>> CLASS_DATA = new IdentityHashMap<Class<? extends BaseConfig>, Set<Field>>();
    private final transient Set<Field> classData = CLASS_DATA.computeIfAbsent(this.getClass(), aClass -> {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            if (Modifier.isFinal(field.getModifiers())) {
                throw new IllegalStateException("All config fields must not be final!");
            }
            fields.add(field);
        }
        return fields;
    });

    public BaseConfig copy() {
        try {
            BaseConfig instance = (BaseConfig)this.getClass().getConstructors()[0].newInstance(new Object[0]);
            for (Field field : this.classData) {
                field.set(instance, field.get(this));
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseConfig)) {
            return false;
        }
        BaseConfig bc = (BaseConfig)obj;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        try {
            for (Field field : this.classData) {
                if (Objects.equals(field.get(bc), field.get(this))) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.classData.stream().map(field -> {
            try {
                return field.get(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Object[]::new));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName().substring(this.getClass().getPackageName().length() + 1));
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        try {
            for (Field field : this.classData) {
                joiner.add(Objects.toString(field.get(this)));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return builder.append(joiner).toString();
    }
}

