/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.config.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.config.BootstrapConfig;
import dev.zenfyr.andromeda.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Logger;

public final class BootstrapConfigHandler {
    @Generated
    private static final Logger log = Util.logger();
    private final Path basePath = FabricLoader.getInstance().getConfigDir().resolve("andromeda");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<Class<?>, BootstrapConfig> configs = new IdentityHashMap();

    public BootstrapConfig get(Module module) {
        return this.configs.get(module.getClass());
    }

    private BootstrapConfig loadImpl(Module module) {
        BootstrapConfig bootstrapConfig;
        block10: {
            Path path = this.basePath.resolve(ModuleHelper.id(module) + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                return BootstrapConfig.create(module);
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (object.has("bootstrap")) {
                    object = object.getAsJsonObject("bootstrap");
                }
                bootstrapConfig = Objects.requireNonNull((BootstrapConfig)this.gson.fromJson((JsonElement)object, BootstrapConfig.class));
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Util.create("Failed to load %s!".formatted(path));
                }
            }
            reader.close();
        }
        return bootstrapConfig;
    }

    public BootstrapConfig load(Module module) {
        BootstrapConfig cfg = this.loadImpl(module);
        this.configs.put(module.getClass(), cfg);
        return cfg;
    }

    public void save(Module module) {
        if (!this.configs.containsKey(module.getClass())) {
            throw new IllegalStateException("Config for module %s is not loaded".formatted(ModuleHelper.id(module)));
        }
        Path path = this.basePath.resolve(ModuleHelper.id(module) + ".json");
        JsonObject object = new JsonObject();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (IOException | RuntimeException e) {
                Util.throwIfDev(() -> new RuntimeException("Failed to load %s!".formatted(path), e));
                object = new JsonObject();
            }
        }
        JsonObject o = this.gson.toJsonTree((Object)this.get(module)).getAsJsonObject();
        if (!object.has("bootstrap")) {
            o.asMap().keySet().forEach(arg_0 -> ((JsonObject)object).remove(arg_0));
        }
        object.add("bootstrap", (JsonElement)o);
        try {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)this.gson.toJson((JsonElement)object), new OpenOption[0]);
        }
        catch (IOException e) {
            throw Util.create("Failed to save %s!".formatted(path));
        }
    }
}

