/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.config.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.zenfyr.andromeda.bootstrap.config.BaseConfig;
import dev.zenfyr.andromeda.bootstrap.config.ModInitConfig;
import dev.zenfyr.andromeda.util.Debug;
import dev.zenfyr.andromeda.util.NetUtils;
import dev.zenfyr.andromeda.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Logger;

public class ModConfigHandler {
    @Generated
    private static final Logger log = Util.logger();
    private static final List<Key<?>> KEYS = new ArrayList();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("andromeda/mod.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<Key<?>, BaseConfig> configs = new IdentityHashMap();

    public static ModConfigHandler load() {
        ModConfigHandler config;
        block12: {
            config = new ModConfigHandler();
            try {
                if (Files.exists(PATH, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(PATH);){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        for (Key<?> key : KEYS) {
                            if (json.has(key.key())) {
                                config.configs.put(key, (BaseConfig)GSON.fromJson(json.get(key.key()), key.type()));
                                continue;
                            }
                            config.configs.put(key, (BaseConfig)key.type().getConstructors()[0].newInstance(new Object[0]));
                        }
                        break block12;
                    }
                }
                for (Key<?> key : KEYS) {
                    config.configs.put(key, (BaseConfig)key.type().getConstructors()[0].newInstance(new Object[0]));
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw Util.create("Failed to load main mod config!");
            }
        }
        return config;
    }

    public void save() {
        try {
            Path parent = PATH.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            JsonObject object = new JsonObject();
            for (Key<?> key : KEYS) {
                object.add(key.key(), GSON.toJsonTree((Object)this.configs.get(key), key.type()));
            }
            Files.writeString(PATH, (CharSequence)GSON.toJson((JsonElement)object), new OpenOption[0]);
        }
        catch (IOException e) {
            Util.throwIfDev(() -> Util.wrap("Failed to save main mod config!", e));
            log.error("Failed to save main mod config!", (Throwable)e);
        }
    }

    public <C extends BaseConfig> C get(Key<C> key) {
        return (C)this.configs.get(key);
    }

    static {
        KEYS.add(ModInitConfig.KEY);
        KEYS.add(NetUtils.KEY);
        KEYS.add(Debug.KEY);
    }

    public record Key<C extends BaseConfig>(String key, Class<C> type) {
        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

