/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.event.bus;

import dev.zenfyr.andromeda.bootstrap.event.bus.Bus;
import java.lang.reflect.Array;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;

public class BusImpl<T>
implements Bus<T> {
    private T[] listeners;
    private T invoker;
    private final Function<T[], T> factory;

    BusImpl(Class<T> type, Function<T[], T> factory) {
        this.factory = factory;
        this.listeners = (Object[])Array.newInstance(type, 0);
        this.rebuildInvoker();
    }

    private void rebuildInvoker() {
        this.invoker = this.factory.apply((T[][])this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(T listener) {
        BusImpl busImpl = this;
        synchronized (busImpl) {
            this.listeners = ArrayUtils.add((Object[])this.listeners, listener);
            this.rebuildInvoker();
        }
    }

    @Override
    public T invoker() {
        return this.invoker;
    }
}

