/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.util.mixin;

import com.google.common.collect.ImmutableList;
import dev.zenfyr.andromeda.bootstrap.util.mixin.MixinEnvironment;
import dev.zenfyr.andromeda.util.ClassPath;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.mixin.AsmUtil;
import dev.zenfyr.pulsar.util.ExceptionUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class AndromedaMixinPlugin
implements IMixinConfigPlugin {
    public static final ClassPath CLASS_PATH = new ClassPath();
    private static final Set<String> CLOTH_MIXINS = Set.of("SubCategoryListEntryMixin", "MultiElementListEntryAccessor");
    private String mixinPackage;

    public static List<String> discoverInPackage(String pck) {
        return (List)CLASS_PATH.getTopLevelRecursive(pck).stream().map(info -> {
            ClassReader reader = new ClassReader((byte[])ExceptionUtil.supply(info::readAllBytes));
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 7);
            return node;
        }).filter(AndromedaMixinPlugin::testMixinEnvironment).map(n -> n.name.replace('/', '.').substring((pck + ".").length())).collect(ImmutableList.toImmutableList());
    }

    public static boolean testMixinEnvironment(ClassNode node) {
        EnvType current = FabricLoader.getInstance().getEnvironmentType();
        AnnotationNode envNode = Annotations.getInvisible((ClassNode)node, MixinEnvironment.class);
        if (envNode != null) {
            EnvType value = (EnvType)AsmUtil.getAnnotationValue((AnnotationNode)envNode, (String)"value", null);
            return current == value;
        }
        return true;
    }

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        CLASS_PATH.addPaths(((ModContainer)FabricLoader.getInstance().getModContainer("andromeda").orElseThrow()).getRootPaths());
        if (!Files.exists(Util.HIDDEN_PATH, new LinkOption[0])) {
            try {
                Files.createDirectories(Util.HIDDEN_PATH, new FileAttribute[0]);
                if (Util.HIDDEN_PATH.getFileSystem().supportedFileAttributeViews().contains("dos")) {
                    Files.setAttribute(Util.HIDDEN_PATH, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return AndromedaMixinPlugin.discoverInPackage(this.mixinPackage).stream().filter(mixinClassName -> !CLOTH_MIXINS.contains(mixinClassName) || FabricLoader.getInstance().isModLoaded("cloth-config")).toList();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

