/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.bootstrap.util.mixin;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.util.mixin.AndromedaMixinPlugin;
import dev.zenfyr.andromeda.bootstrap.util.mixin.ModuleMixinPlugin;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.mixin.VirtualMixins;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixins;

public class MixinHandler {
    @Generated
    private static final Logger log = Util.logger();
    public static final String NOTICE = "mixin_processor.config_notice";
    public static final String JAVA_VERSION = "JAVA_17";
    public static final String MIXIN_VERSION = "0.8.5";
    private final ModuleManager manager;
    private final Map<String, Module> mixinConfigs = new HashMap<String, Module>();
    private final Map<String, List<String>> mixinClasses = new HashMap<String, List<String>>();

    public MixinHandler(ModuleManager manager) {
        this.manager = manager;
    }

    @ApiStatus.Internal
    public Optional<Module> fromConfig(String name) {
        return Optional.ofNullable(this.mixinConfigs.get(name));
    }

    @ApiStatus.Internal
    public List<String> mixinsFromPackage(@Nullable String pkg) {
        if (pkg == null) {
            return Collections.emptyList();
        }
        return this.mixinClasses.getOrDefault(pkg, Collections.emptyList());
    }

    public void addMixins() {
        for (Module module : this.manager.loaded()) {
            String pkg = ModuleHelper.mixinPackage(module);
            List<String> list = AndromedaMixinPlugin.discoverInPackage(pkg);
            if (list.isEmpty()) continue;
            this.mixinClasses.put(pkg, list);
        }
        VirtualMixins.addMixins(acceptor -> {
            for (Module module : this.manager.loaded()) {
                if (!this.mixinClasses.containsKey(ModuleHelper.mixinPackage(module))) continue;
                JsonObject config = this.createConfig(module);
                String cfg = "andromeda_dynamic$$" + ModuleHelper.dotted(module);
                try (ByteArrayInputStream bais = new ByteArrayInputStream(config.toString().getBytes(StandardCharsets.UTF_8));){
                    acceptor.add(cfg, (InputStream)bais);
                    this.mixinConfigs.put(cfg, module);
                }
                catch (IOException e) {
                    throw Util.wrap("Failed to create mixin config %s".formatted(cfg), e);
                }
            }
        });
        Set set = Mixins.getConfigs();
        if (set instanceof HashSet) {
            HashSet hs = (HashSet)set;
            set = (HashSet)hs.clone();
        } else {
            log.warn("Mixins.getConfigs() is not a HashSet?");
            set = ImmutableSet.copyOf((Collection)set);
        }
        set.forEach(config -> {
            if (this.mixinConfigs.containsKey(config.getName())) {
                config.getConfig().decorate("fabric-modId", (Object)"andromeda");
            }
        });
    }

    public JsonObject createConfig(Module module) {
        JsonObject object = new JsonObject();
        object.addProperty("required", Boolean.valueOf(true));
        object.addProperty("minVersion", MIXIN_VERSION);
        object.addProperty("package", module.getClass().getPackageName() + ".mixin");
        object.addProperty("compatibilityLevel", JAVA_VERSION);
        object.addProperty("plugin", ModuleMixinPlugin.class.getName());
        object.addProperty("refmap", "andromeda-refmap.json");
        JsonObject injectors = new JsonObject();
        injectors.addProperty("defaultRequire", (Number)1);
        injectors.addProperty("maxShiftBy", (Number)3);
        object.add("injectors", (JsonElement)injectors);
        return object;
    }
}

