/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.client.config;

import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.config.BootstrapConfig;
import dev.zenfyr.andromeda.bootstrap.config.ConfigDefinition;
import dev.zenfyr.andromeda.bootstrap.config.handler.BootstrapConfigHandler;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.client.AndromedaClient;
import dev.zenfyr.andromeda.common.client.config.ClothTooltipUtil;
import dev.zenfyr.andromeda.common.client.config.EntryProviders;
import dev.zenfyr.andromeda.common.config.handler.MultiConfigHandler;
import dev.zenfyr.andromeda.common.mixin.MultiElementListEntryAccessor;
import dev.zenfyr.pulsar.util.TextUtil;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoConfigScreen {
    public static final class_2561 RESET_BUTTON_KEY = class_2561.method_43471((String)"text.cloth-config.reset_value");
    private final ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
    private final IdentityHashMap<Class<?>, Entry<?>> providers = new IdentityHashMap();
    private final Map<@NotNull MultiConfigHandler, @NotNull String> handlers;
    private final Entry<Object> objectEntry;
    private final Entry<Enum<?>> enumEntry;

    public AutoConfigScreen() {
        EntryProviders.init(this);
        this.handlers = Map.of(Andromeda.MAIN, "main", Andromeda.GAME, "game", AndromedaClient.CLIENT, "client");
        this.objectEntry = this.providers.get(Object.class);
        this.enumEntry = this.providers.get(Enum.class);
    }

    public ConfigEntryBuilder entryBuilder() {
        return this.entryBuilder;
    }

    public <T> void register(Class<T> type, EntryFunction<T> entryFunction, Function<Class<?>, T> def) {
        this.providers.put(type, new Entry(context -> {
            AbstractConfigListEntry<?> entry = entryFunction.getEntry(context);
            if (context.field() != null && context.field().isAnnotationPresent(ConfigEntry.Gui.RequiresRestart.class)) {
                entry.setRequiresRestart(true);
            }
            if (context.module() != null) {
                ClothTooltipUtil.setEntryTooltip(entry, context.i18n() + ".@Tooltip");
            }
            return ClothTooltipUtil.wrapTooltip(entry);
        }, def));
    }

    public <T> Entry<T> getEntry(Class<T> type) {
        Entry<?> e = this.providers.get(type);
        if (e != null) {
            return e;
        }
        if (type.isEnum() || Enum.class.isAssignableFrom(type)) {
            return this.enumEntry;
        }
        return this.objectEntry;
    }

    public class_437 getScreen(class_437 parent) {
        IdentityHashMap saveQueue = new IdentityHashMap();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)TextUtil.translatable((String)"config.andromeda.title", (Object[])new Object[]{"67"})).setSavingRunnable(() -> {
            saveQueue.values().forEach(Runnable::run);
            saveQueue.clear();
        }).setDefaultBackgroundTexture(class_2960.method_43902((String)"minecraft", (String)"textures/block/amethyst_block.png"));
        BootstrapConfigHandler bootstrapHandler = ModuleManager.get().configHandler();
        for (Module module : ModuleManager.get().all().stream().sorted(Comparator.comparing(ModuleHelper::id)).toList()) {
            ConfigCategory category = builder.getOrCreateCategory((class_2561)TextUtil.translatable((String)"config.andromeda.category.%s".formatted(module.meta().category())));
            String moduleText = "config.andromeda.%s".formatted(ModuleHelper.dotted(module.meta()));
            SubCategoryBuilder moduleCategory = this.entryBuilder().startSubCategory((class_2561)TextUtil.translatable((String)moduleText));
            this.handlers.forEach((handler, state) -> {
                ConfigDefinition definition = handler.getDefinition(module);
                if (definition == null) {
                    return;
                }
                String stateKey = "config.andromeda.state.%s".formatted(state);
                SubCategoryBuilder stateCategory = this.entryBuilder().startSubCategory((class_2561)TextUtil.translatable((String)stateKey));
                Object config = handler.get(definition);
                Object defConfig = handler.getDefault(definition);
                AbstractConfigListEntry<?> e = this.objectEntry.function().getEntry(AutoConfigScreen.makeRootCtx(config, defConfig, o -> saveQueue.put(definition, () -> handler.save(module)), moduleText, module));
                stateCategory.addAll(((MultiElementListEntryAccessor)e).pulsar$entries());
                if (!stateCategory.isEmpty()) {
                    moduleCategory.add((AbstractConfigListEntry)stateCategory.build());
                }
            });
            class_5250 rootI18n = moduleCategory.isEmpty() ? TextUtil.translatable((String)moduleText) : TextUtil.translatable((String)"config.andromeda.option.enabled");
            BootstrapConfig bootstrapConfig = bootstrapHandler.get(module);
            BooleanListEntry rootToggle = this.entryBuilder().startBooleanToggle((class_2561)rootI18n, bootstrapConfig.enabled).setDefaultValue(() -> false).setSaveConsumer(b -> {
                bootstrapConfig.enabled = b;
                saveQueue.put(bootstrapConfig, () -> bootstrapHandler.save(module));
            }).requireRestart().build();
            if (moduleCategory.isEmpty()) {
                category.addEntry((AbstractConfigListEntry)ClothTooltipUtil.standardForModule(rootToggle, module, "enabled"));
                continue;
            }
            moduleCategory.add(0, (AbstractConfigListEntry)rootToggle);
            category.addEntry((AbstractConfigListEntry)ClothTooltipUtil.standardForModule(moduleCategory.build(), module, null));
        }
        return builder.build();
    }

    private static <T> EntryContext<T> makeRootCtx(T value, T def, Consumer<T> consumer, String i18n, Module module) {
        return new EntryContext<T>(value.getClass(), value, def, consumer, i18n, null, module);
    }

    public record Entry<T>(EntryFunction<T> function, Function<Class<?>, T> def) {
    }

    public static interface EntryFunction<T> {
        public AbstractConfigListEntry<?> getEntry(EntryContext<T> var1);
    }

    public record EntryContext<T>(Class<?> type, T value, @Nullable T def, Consumer<T> consumer, String i18n, Field field, Module module) {
        @Generated
        public EntryContext<T> withType(Class<?> type) {
            return this.type == type ? this : new EntryContext<T>(type, this.value, this.def, this.consumer, this.i18n, this.field, this.module);
        }

        @Generated
        public EntryContext<T> withValue(T value) {
            return this.value == value ? this : new EntryContext<T>(this.type, value, this.def, this.consumer, this.i18n, this.field, this.module);
        }

        @Generated
        public EntryContext<T> withDef(@Nullable T def) {
            return this.def == def ? this : new EntryContext<T>(this.type, this.value, def, this.consumer, this.i18n, this.field, this.module);
        }

        @Generated
        public EntryContext<T> withConsumer(Consumer<T> consumer) {
            return this.consumer == consumer ? this : new EntryContext<T>(this.type, this.value, this.def, consumer, this.i18n, this.field, this.module);
        }

        @Generated
        public EntryContext<T> withI18n(String i18n) {
            return this.i18n == i18n ? this : new EntryContext<T>(this.type, this.value, this.def, this.consumer, i18n, this.field, this.module);
        }

        @Generated
        public EntryContext<T> withField(Field field) {
            return this.field == field ? this : new EntryContext<T>(this.type, this.value, this.def, this.consumer, this.i18n, field, this.module);
        }

        @Generated
        public EntryContext<T> withModule(Module module) {
            return this.module == module ? this : new EntryContext<T>(this.type, this.value, this.def, this.consumer, this.i18n, this.field, module);
        }
    }
}

