/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.config.BaseConfig;
import dev.zenfyr.andromeda.bootstrap.config.ConfigDefinition;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.config.handler.GameConfigHandler;
import dev.zenfyr.andromeda.common.util.IdentifiedJsonDataLoader;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.resources.ReloaderType;
import dev.zenfyr.pulsar.resources.ServerReloadersEvent;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public final class DataConfigs
extends IdentifiedJsonDataLoader {
    @Generated
    private static final Logger log = Util.logger();
    public static final class_2960 DEFAULT = Andromeda.id("default");
    public static final ReloaderType<DataConfigs> RELOADER = ReloaderType.create((class_2960)Andromeda.id("scoped_config"));
    private final ModuleManager moduleManager;
    public Map<class_2960, Map<Module, Set<Data>>> configs;
    public Map<Module, Set<Data>> defaultConfigs;

    public static DataConfigs get(MinecraftServer server) {
        return (DataConfigs)server.pulsar$getReloader(RELOADER);
    }

    public DataConfigs(ModuleManager moduleManager) {
        super(RELOADER.location());
        this.moduleManager = moduleManager;
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, Map<Module, Set<Data>>> parsed = new HashMap<class_2960, Map<Module, Set<Data>>>();
        for (Map.Entry entry : Maps.transformValues(data, JsonElement::getAsJsonObject).entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            JsonObject json = (JsonObject)entry.getValue();
            Module module = (Module)this.moduleManager.get(id.method_12832()).orElseThrow(() -> new IllegalStateException("Invalid module path '%s'! The module must be enabled!".formatted(id.method_12832())));
            Class type = Andromeda.GAME.getDefinition(module).supplier().get();
            Maps.transformValues((Map)json.asMap(), JsonElement::getAsJsonObject).forEach((string, value) -> {
                class_2960 dimension = new class_2960(string);
                BaseConfig cfg = (BaseConfig)Andromeda.GAME.gson().fromJson((JsonElement)value, type);
                ReferenceOpenHashSet overrides = new ReferenceOpenHashSet();
                for (String field : value.keySet()) {
                    try {
                        overrides.add(type.getField(field));
                    }
                    catch (NoSuchFieldException e) {
                        throw Util.wrap("No such field '%s' for module %s".formatted(field, id), e);
                    }
                }
                parsed.computeIfAbsent(dimension, i_ -> new HashMap()).computeIfAbsent(module, m_ -> new ReferenceLinkedOpenHashSet()).add(new Data((Set<Field>)overrides, cfg));
            });
        }
        this.defaultConfigs = (Map)parsed.remove(DEFAULT);
        this.configs = parsed;
    }

    public void applyConfigs(AttachmentGetter getter, class_2960 dimension) {
        Objects.requireNonNull(this.configs);
        GameConfigHandler handler = getter.andromeda$getConfigs();
        handler.loadAll();
        handler.forEach((module, baseConfig) -> this.applyDataPacks((BaseConfig)baseConfig, (Module)module, dimension));
    }

    void applyDataPacks(BaseConfig config, Module module, class_2960 dimension) {
        Set<Data> forModule;
        Set<Data> forModule2;
        if (this.defaultConfigs != null && (forModule2 = this.defaultConfigs.get(module)) != null) {
            for (Data data : forModule2) {
                this.apply(config, data);
            }
        }
        if (dimension.equals((Object)DEFAULT)) {
            return;
        }
        Map<Module, Set<Data>> overrides = Objects.requireNonNull(this.configs).get(dimension);
        if (overrides != null && (forModule = overrides.get(module)) != null) {
            for (Data data1 : forModule) {
                this.apply(config, data1);
            }
        }
    }

    private void apply(BaseConfig config, Data data) {
        data.cFields().forEach(field -> {
            try {
                field.set(config, field.get(data.config()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to apply config data for module '%s'".formatted(config.getClass().getSimpleName()), e);
            }
        });
    }

    public static void init(ModuleManager manager) {
        ServerReloadersEvent.EVENT.register(context -> context.register((IdentifiableResourceReloadListener)new DataConfigs(manager)));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (!success) {
                return;
            }
            DataConfigs configs = DataConfigs.get(server);
            for (class_3218 world : server.method_3738()) {
                configs.applyConfigs((AttachmentGetter)world, world.method_27983().method_29177());
            }
        });
    }

    public static interface AttachmentGetter {
        public GameConfigHandler andromeda$getConfigs();
    }

    public record Data(Set<Field> cFields, BaseConfig config) {
    }

    public static interface WorldExtension {
        default public <T extends BaseConfig> T am$get(ConfigDefinition<T> definition) {
            log.error("Scoped configs requested on client in world '{}'! Returning un-scoped!", (Object)((class_1937)this).method_27983().method_29177());
            return Andromeda.MAIN.get(definition);
        }
    }
}

