/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.config.handler;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleHelper;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.config.BaseConfig;
import dev.zenfyr.andromeda.bootstrap.config.ConfigDefinition;
import dev.zenfyr.andromeda.bootstrap.config.RegisterConfigEvent;
import dev.zenfyr.andromeda.bootstrap.event.EventMarker;
import dev.zenfyr.andromeda.bootstrap.event.bus.Bus;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import lombok.Generated;

public abstract class AbstractConfigHandler {
    private final Map<ConfigDefinition<?>, BaseConfig> configs = new IdentityHashMap();
    private final Map<ConfigDefinition<?>, BaseConfig> defaultConfigs = new IdentityHashMap();
    private final Path basePath;
    private final Map<Module, ConfigDefinition<?>> definitions = new LinkedHashMap();
    protected final Gson gson;

    public AbstractConfigHandler(ModuleManager manager, Path path, EventMarker<RegisterConfigEvent> id) {
        this.basePath = path;
        this.gson = Andromeda.buildGson();
        for (Module module : this.modules(manager)) {
            ConfigDefinition<?> old;
            ConfigDefinition<?> def;
            Bus<RegisterConfigEvent> bus = module.getOrCreateBus(id, null);
            if (bus == null || (def = bus.invoker().onRegisterConfigs()) == null || (old = this.definitions.put(module, def)) == null) continue;
            throw new IllegalStateException();
        }
    }

    protected abstract Collection<Module> modules(ModuleManager var1);

    public Path resolve(Module module) {
        return this.basePath.resolve("andromeda/" + ModuleHelper.id(module) + ".json");
    }

    public <T extends BaseConfig> ConfigDefinition<T> getDefinition(Module module) {
        return this.definitions.get(module);
    }

    public <T extends BaseConfig> T get(ConfigDefinition<T> module) {
        return (T)this.configs.get(module);
    }

    public void forEach(BiConsumer<Module, BaseConfig> consumer) {
        this.definitions.forEach((? super K module, ? super V definition) -> consumer.accept((Module)module, (BaseConfig)this.get((ConfigDefinition)definition)));
    }

    protected <T extends BaseConfig> T createDefault(ConfigDefinition<T> module) {
        try {
            return (T)((BaseConfig)module.supplier().get().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Util.wrap("Failed to default new config from invalid config definition (%s).".formatted(module.supplier().get().getName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseConfig> T getDefault(ConfigDefinition<T> module) {
        BaseConfig entry = this.defaultConfigs.get(module);
        if (entry == null) {
            Map<ConfigDefinition<?>, BaseConfig> map = this.defaultConfigs;
            synchronized (map) {
                entry = this.createDefault(module);
                this.defaultConfigs.put(module, entry);
            }
        }
        return (T)entry;
    }

    protected abstract void writeToFile(Path var1, BaseConfig var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Module module) {
        if (!this.definitions.containsKey(module)) {
            throw new IllegalStateException(ModuleHelper.id(module));
        }
        Path path = this.resolve(module);
        Object entry = this.get(this.getDefinition(module));
        ConfigDefinition configDefinition = this.getDefinition(module);
        synchronized (configDefinition) {
            try {
                this.writeToFile(path, (BaseConfig)entry);
            }
            catch (IOException e) {
                throw Util.wrap("Failed to save config to file (%s)".formatted(path), e);
            }
        }
    }

    protected <T extends BaseConfig> T createNewConfig(Module module, ConfigDefinition<T> definition) {
        try {
            return (T)((BaseConfig)definition.supplier().get().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Util.wrap("Failed to create new config for '%s' from invalid config definition.".formatted(ModuleHelper.id(module)), e);
        }
    }

    protected abstract BaseConfig readFromFile(Path var1, ConfigDefinition<?> var2) throws IOException;

    public BaseConfig load(Module module) {
        if (!this.definitions.containsKey(module)) {
            throw new IllegalStateException(ModuleHelper.id(module));
        }
        ConfigDefinition definition = this.getDefinition(module);
        Path path = this.resolve(module);
        if (!Files.exists(path, new LinkOption[0])) {
            return this.createNewConfig(module, definition);
        }
        ConfigDefinition configDefinition = definition;
        synchronized (configDefinition) {
            try {
                return this.readFromFile(path, definition);
            }
            catch (IOException e) {
                throw Util.wrap("Failed to read config %s from file".formatted(path), e);
            }
        }
    }

    public void saveAll() {
        CompletableFuture.allOf((CompletableFuture[])this.definitions.keySet().stream().map(module -> CompletableFuture.runAsync(() -> this.save((Module)module))).toArray(CompletableFuture[]::new)).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        IdentityHashMap configs = new IdentityHashMap();
        for (Map.Entry<Module, ConfigDefinition<?>> entry : this.definitions.entrySet()) {
            configs.put(entry.getValue(), CompletableFuture.supplyAsync(() -> this.load((Module)entry.getKey())));
        }
        Map<ConfigDefinition<?>, BaseConfig> map = this.configs;
        synchronized (map) {
            this.configs.putAll(Maps.transformValues(configs, CompletableFuture::join));
        }
    }

    @Generated
    public Gson gson() {
        return this.gson;
    }
}

