/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.config.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.zenfyr.andromeda.bootstrap.Module;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.bootstrap.config.BaseConfig;
import dev.zenfyr.andromeda.bootstrap.config.ConfigDefinition;
import dev.zenfyr.andromeda.bootstrap.config.RegisterConfigEvent;
import dev.zenfyr.andromeda.bootstrap.event.EventMarker;
import dev.zenfyr.andromeda.common.config.handler.AbstractConfigHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;

public class MultiConfigHandler
extends AbstractConfigHandler {
    private final String state;

    public MultiConfigHandler(ModuleManager manager, Path path, String state, EventMarker<RegisterConfigEvent> id) {
        super(manager, path, id);
        this.state = state;
    }

    @Override
    protected Collection<Module> modules(ModuleManager manager) {
        return manager.all();
    }

    @Override
    protected void writeToFile(Path path, BaseConfig entry) throws IOException {
        Path parent;
        JsonObject o;
        JsonObject object;
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (JsonParseException | IOException e) {
                object = new JsonObject();
            }
        } else {
            object = new JsonObject();
        }
        if (!(o = this.gson.toJsonTree((Object)entry).getAsJsonObject()).asMap().isEmpty()) {
            object.add(this.state, (JsonElement)o);
            o.keySet().forEach(arg_0 -> ((JsonObject)object).remove(arg_0));
        }
        if ((parent = path.getParent()) != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.writeString(path, (CharSequence)this.gson.toJson((JsonElement)object), new OpenOption[0]);
    }

    @Override
    protected BaseConfig readFromFile(Path path, ConfigDefinition<?> definition) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (!element.isJsonObject()) {
                throw new IllegalStateException("Not a JsonObject!");
            }
            JsonObject object = element.getAsJsonObject();
            object = Objects.requireNonNullElse(object.getAsJsonObject(this.state), object);
            BaseConfig baseConfig = Objects.requireNonNull((BaseConfig)this.gson.fromJson((JsonElement)object, definition.supplier().get()));
            return baseConfig;
        }
    }
}

