/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;

public record GsonCodecContext<C>(Codec<C> codec) implements JsonSerializer<C>,
JsonDeserializer<C>
{
    public static <C> GsonCodecContext<C> of(Codec<C> codec) {
        return new GsonCodecContext<C>(codec);
    }

    public C deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DataResult r = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (r.error().isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)r.error().orElseThrow()).message());
        }
        return (C)r.result().orElseThrow();
    }

    public JsonElement serialize(C src, Type typeOfSrc, JsonSerializationContext context) {
        DataResult r = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, src);
        if (r.error().isPresent()) {
            throw new IllegalStateException(((DataResult.PartialResult)r.error().orElseThrow()).message());
        }
        return (JsonElement)r.result().orElseThrow();
    }
}

