/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.common.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public final class Keeper<T> {
    private volatile boolean initialized;
    @Nullable
    private T value;

    public static <T> Keeper<T> create() {
        return new Keeper<T>();
    }

    public static <T> Keeper<T> now(T value) {
        Keeper<T> keeper = Keeper.create();
        keeper.init(value);
        return keeper;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nullable T value) {
        if (this.initialized) {
            return;
        }
        Keeper keeper = this;
        synchronized (keeper) {
            if (this.initialized) {
                return;
            }
            this.value = value;
            this.initialized = true;
        }
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public T orThrow() {
        return this.orThrow("No value present! Keeper not bootstrapped?");
    }

    public T orThrow(String msg) {
        return this.orThrow(() -> new IllegalStateException(msg));
    }

    public <X extends Throwable> T orThrow(Supplier<X> e) throws X {
        if (this.value == null) {
            throw (Throwable)e.get();
        }
        return this.value;
    }
}

