/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.gui.item_frame_tooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.zenfyr.pulsar.util.Utilities;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.joml.Vector2i;

public class Client {
    private Supplier<List<class_5684>> action;
    private float tooltipFlow;
    private float oldTooltipFlow;
    private static final Map<Predicate<class_3966>, Function<class_3966, List<class_5684>>> ENTITY_LOOKUP = new Reference2ObjectOpenHashMap();

    Client() {
        this.inGameTooltips();
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            class_239 cast = client.field_1765;
            this.getCast(cast);
            this.oldTooltipFlow = this.tooltipFlow;
            float f = this.tooltipFlow = this.action != null ? class_3532.method_16439((float)0.25f, (float)this.tooltipFlow, (float)1.0f) : class_3532.method_16439((float)0.1f, (float)this.tooltipFlow, (float)0.0f);
            if (Math.abs(this.tooltipFlow) < 1.0E-5f) {
                this.tooltipFlow = 0.0f;
            }
        });
    }

    public static void registerEntityTooltip(Predicate<class_3966> predicate, Function<class_3966, List<class_5684>> function) {
        ENTITY_LOOKUP.put(predicate, function);
    }

    private void inGameTooltips() {
        HudRenderCallback.EVENT.register((context, delta) -> {
            if (class_310.method_1551().field_1755 == null) {
                class_310 client = class_310.method_1551();
                if (this.action != null) {
                    this.renderFromComponents(client, context, this.action.get());
                }
            }
        });
        Client.registerEntityTooltip(entityHitResult -> {
            class_1533 ife;
            class_1297 patt0$temp = entityHitResult.method_17782();
            return patt0$temp instanceof class_1533 && !(ife = (class_1533)patt0$temp).method_6940().method_7960();
        }, entityHitResult -> {
            class_1799 frameStack = ((class_1533)entityHitResult.method_17782()).method_6940();
            if (frameStack.method_7960()) {
                return Collections.emptyList();
            }
            List list = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)frameStack);
            List components = list.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toCollection(ArrayList::new));
            frameStack.method_32347().ifPresent(datax -> components.add(1, (class_5684)Utilities.supply(() -> {
                class_5684 component = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(datax);
                if (component == null) {
                    component = class_5684.method_32663((class_5632)datax);
                }
                return component;
            })));
            return components;
        });
    }

    private void getCast(class_239 cast) {
        if (cast != null && cast.method_17783() == class_239.class_240.field_1331) {
            class_3966 hitResult = (class_3966)cast;
            Optional<Map.Entry> opt = ENTITY_LOOKUP.entrySet().stream().filter(p -> ((Predicate)p.getKey()).test(hitResult)).findFirst();
            if (opt.isPresent()) {
                this.action = () -> (List)((Function)((Map.Entry)opt.get()).getValue()).apply(hitResult);
                return;
            }
        }
        this.action = null;
    }

    private void renderFromComponents(class_310 client, class_332 context, List<class_5684> components) {
        if (components.isEmpty()) {
            return;
        }
        float flow = class_3532.method_16439((float)client.method_1488(), (float)this.oldTooltipFlow, (float)this.tooltipFlow);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, -450.0f);
        matrices.method_22905(1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(flow, 0.8f));
        context.method_51435(client.field_1772, components, 0, 0, (screenWidth, screenHeight, sameX, sameY, width, height) -> {
            float smoothX = (float)screenWidth / 2.0f - flow * 15.0f + 27.0f;
            float smoothY = (float)(client.method_22683().method_4502() - height) / 2.0f;
            matrices.method_46416(smoothX - (float)((int)smoothX), smoothY - (float)((int)smoothY), 1.0f);
            return new Vector2i((int)smoothX, (int)smoothY);
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrices.method_22909();
    }
}

