/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.items.magnet;

import com.google.common.collect.ImmutableSet;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.items.magnet.Magnet;
import dev.zenfyr.pulsar.client.particles.ScreenParticleHelper;
import dev.zenfyr.pulsar.util.MathUtil;
import dev.zenfyr.pulsar.util.SupportUtil;
import dev.zenfyr.pulsar.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MagnetItem
extends class_1792 {
    public static final Keeper<MagnetItem> MAGNET = Keeper.create();
    private static final BiConsumer<class_1799, class_1657> ITEM_PARTICLES = (BiConsumer)SupportUtil.support((EnvType)EnvType.CLIENT, () -> MagnetItem::itemParticles, () -> (stack, player) -> {});
    private static final Consumer<class_1657> UPGRADE_PARTICLES = (Consumer)SupportUtil.support((EnvType)EnvType.CLIENT, () -> MagnetItem::upgradeParticles, () -> stack -> {});
    public static final String LEVEL_KEY = "PowerLevel";

    public MagnetItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014) {
            class_1799 itemStack = slot.method_7677();
            if (itemStack.method_7960()) {
                MagnetItem.removeFirst(stack);
                this.playRemoveOneSound((class_1297)player);
            } else {
                MagnetItem.addFirst(stack, itemStack);
                ITEM_PARTICLES.accept(itemStack, player);
                this.playInsertSound((class_1297)player);
            }
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014) {
            if (otherStack.method_7960()) {
                MagnetItem.removeFirst(stack);
                this.playRemoveOneSound((class_1297)player);
            } else {
                MagnetItem.addFirst(stack, otherStack);
                ITEM_PARTICLES.accept(otherStack, player);
                this.playInsertSound((class_1297)player);
            }
            return true;
        }
        if (clickType == class_5536.field_27013 && otherStack.method_31574(class_1802.field_8207)) {
            if (MagnetItem.incrementLevel(stack)) {
                otherStack.method_7934(1);
                UPGRADE_PARTICLES.accept(player);
                this.playUpgradeSound((class_1297)player);
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void upgradeParticles(class_1657 player) {
        if (player.field_6002.method_8608()) {
            class_310 client = class_310.method_1551();
            int x = (int)(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480());
            int y = (int)(client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
            ScreenParticleHelper.addScreenParticles((class_2394)class_2398.field_11207, (double)x, (double)y, (double)0.5, (double)0.5, (double)0.07, (int)7);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void itemParticles(class_1799 stack, class_1657 player) {
        if (player.field_6002.method_8608()) {
            class_310 client = class_310.method_1551();
            int x = (int)(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480());
            int y = (int)(client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
            ScreenParticleHelper.addScreenParticles((class_2394)new class_2392(class_2398.field_11218, stack), (double)x, (double)y, (double)0.5, (double)0.5, (double)0.1, (int)7);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608()) {
            class_1309 pe;
            if (entity instanceof class_1309 ? !class_1799.method_7984((class_1799)stack, (class_1799)(pe = (class_1309)entity).method_5998(class_1268.field_5808)) && !class_1799.method_7984((class_1799)stack, (class_1799)pe.method_5998(class_1268.field_5810)) : !selected) {
                return;
            }
            Set<class_1792> magnetables = MagnetItem.magnetable(stack);
            int level = MagnetItem.getLevel(stack);
            world.method_8390(class_1542.class, new class_238(entity.method_24515()).method_1014((double)level * ((Magnet.Config)world.am$get(Magnet.CONFIG)).rangeMultiplier), ie -> magnetables.contains(((class_1799)ie.method_5841().method_12789(class_1542.field_7199)).method_7909())).forEach(ie -> {
                class_243 vel = ie.method_19538().method_1035(entity.method_19538()).method_1029().method_1021((double)(0.05f * (float)level));
                ie.method_5762(vel.field_1352, vel.field_1351, vel.field_1350);
            });
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        MagnetItem.magnetable(stack).forEach(item -> defaultedList.add((Object)item.method_7854()));
        return Optional.of(new class_5631(defaultedList, Integer.MAX_VALUE));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)TextUtil.translatable((String)"tooltip.andromeda.magnet.level", (Object[])new Object[]{MagnetItem.getLevel(stack)}).method_27692(class_124.field_1080));
    }

    private static boolean incrementLevel(class_1799 stack) {
        int level;
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(LEVEL_KEY)) {
            nbt.method_10569(LEVEL_KEY, 1);
        }
        if ((level = nbt.method_10550(LEVEL_KEY)) >= 5) {
            return false;
        }
        nbt.method_10569(LEVEL_KEY, level + 1);
        return true;
    }

    private static int getLevel(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545(LEVEL_KEY)) {
            return MathUtil.clamp((int)nbt.method_10550(LEVEL_KEY), (int)0, (int)5);
        }
        return 1;
    }

    public static void addFirst(class_1799 bundle, class_1799 other) {
        class_2519 id;
        class_2499 list;
        class_2487 nbt = bundle.method_7948();
        if (!nbt.method_10545("Items")) {
            nbt.method_10566("Items", (class_2520)new class_2499());
        }
        if ((list = nbt.method_10554("Items", 8)).contains((Object)(id = class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)other.method_7909()).toString())))) {
            return;
        }
        list.method_10531(0, (class_2520)id);
    }

    private static void removeFirst(class_1799 stack) {
        class_2499 list;
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("Items") && !(list = nbt.method_10554("Items", 8)).isEmpty()) {
            list.method_10536(0);
            if (list.isEmpty()) {
                stack.method_7983("Items");
            }
        }
    }

    private static Set<class_1792> magnetable(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return Collections.emptySet();
        }
        class_2499 nbtList = nbt.method_10554("Items", 8);
        return (Set)nbtList.stream().map(class_2519.class::cast).map(s -> (class_1792)class_7923.field_41178.method_10223(new class_2960(s.method_10714()))).collect(ImmutableSet.toImmutableSet());
    }

    private void playUpgradeSound(class_1297 entity) {
        entity.method_5783(class_3417.field_15119, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    static void init() {
        Magnet module = ModuleManager.get().get(Magnet.class).orElseThrow();
        MAGNET.init((MagnetItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Andromeda.id("magnet"), (Object)((Object)new MagnetItem(new FabricItemSettings().method_7889(1))))));
        AndromedaItemGroup.BUS.listen(acceptor -> acceptor.keeper(module, (class_5321<class_1761>)class_7706.field_41060, MAGNET));
    }
}

