/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.items.pouches;

import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.AndromedaItemGroup;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.items.pouches.Pouches;
import dev.zenfyr.andromeda.modules.items.pouches.Trades;
import dev.zenfyr.andromeda.modules.items.pouches.entities.PouchEntity;
import dev.zenfyr.andromeda.modules.items.pouches.items.PouchItem;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.itemstack.ItemStackUtil;
import dev.zenfyr.pulsar.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1676;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_5561;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class Main {
    public static final Keeper<PouchItem> SEED_POUCH = Keeper.create();
    public static final Keeper<PouchItem> FLOWER_POUCH = Keeper.create();
    public static final Keeper<PouchItem> SAPLING_POUCH = Keeper.create();
    public static final Keeper<PouchItem> SPECIAL_POUCH = Keeper.create();
    public static final Keeper<class_1299<PouchEntity>> POUCH = Keeper.create();
    private static final Map<class_2591<?>, Field> VIEWABLE_BLOCKS = new HashMap();
    public static final Map<class_2591<?>, Field> VIEWABLE_VIEW = Collections.unmodifiableMap(VIEWABLE_BLOCKS);

    public static int getViewCount(class_2586 be) {
        Field f = VIEWABLE_VIEW.get(be.method_11017());
        if (f != null) {
            class_5561 vcm = (class_5561)ExceptionUtil.supply(() -> f.get(be));
            return vcm.method_31678();
        }
        return -1;
    }

    public static void tryInsertItem(class_1937 world, class_243 pos, class_1799 stack, Storage<ItemVariant> storage) {
        if (stack.method_7960()) {
            return;
        }
        class_1799 itemStack = stack.method_7972();
        try (Transaction transaction = Transaction.openOuter();){
            long i = StorageUtil.tryInsertStacking(storage, (Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            if (i > 0L) {
                transaction.commit();
                itemStack.method_7939((int)((long)stack.method_7947() - i));
            }
        }
        if (!itemStack.method_7960()) {
            ItemStackUtil.spawnVelocity((class_243)pos, (class_1799)itemStack, (class_1937)world, (double)-0.2, (double)0.2, (double)0.1, (double)0.2, (double)-0.2, (double)0.2);
        }
    }

    static void init() {
        Pouches module = ModuleManager.get().get(Pouches.class).orElseThrow();
        Pouches.Config config = Andromeda.MAIN.get(Pouches.MAIN_CONFIG);
        if (config.seedPouch) {
            SEED_POUCH.init((PouchItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Andromeda.id("seed_pouch"), (Object)((Object)new PouchItem(PouchEntity.Type.SEED, new FabricItemSettings().method_7889(16))))));
        }
        if (config.flowerPouch) {
            FLOWER_POUCH.init((PouchItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Andromeda.id("flower_pouch"), (Object)((Object)new PouchItem(PouchEntity.Type.FLOWER, new FabricItemSettings().method_7889(16))))));
        }
        if (config.saplingPouch) {
            SAPLING_POUCH.init((PouchItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Andromeda.id("sapling_pouch"), (Object)((Object)new PouchItem(PouchEntity.Type.SAPLING, new FabricItemSettings().method_7889(16))))));
        }
        if (config.specialPouch) {
            SPECIAL_POUCH.init((PouchItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Andromeda.id("special_pouch"), (Object)((Object)new PouchItem(PouchEntity.Type.CUSTOM, new FabricItemSettings().method_7889(16))))));
        }
        POUCH.init((class_1299<PouchEntity>)((class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)Andromeda.id("pouch"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, PouchEntity::new).dimensions(new class_4048(0.25f, 0.25f, true)).trackRangeChunks(4).trackedUpdateRate(10).build())));
        Trades.register();
        List<Keeper<PouchItem>> l = List.of(SEED_POUCH, FLOWER_POUCH, SAPLING_POUCH, SPECIAL_POUCH);
        AndromedaItemGroup.BUS.listen(acceptor -> acceptor.keepers(module, (class_5321<class_1761>)class_7706.field_41060, new ArrayList<Keeper<? extends class_1935>>(l)));
        class_2965 behavior = new class_2965(){

            protected class_1676 method_12844(class_1937 world, class_2374 position, class_1799 stack) {
                PouchEntity pouch = new PouchEntity(position.method_10216(), position.method_10214(), position.method_10215(), world);
                pouch.setPouchType(((PouchItem)stack.method_7909()).getType());
                return pouch;
            }
        };
        for (Keeper<PouchItem> pouchItemKeeper : l) {
            if (!pouchItemKeeper.isPresent()) continue;
            class_2315.method_10009((class_1935)((class_1935)pouchItemKeeper.orThrow()), (class_2357)behavior);
        }
    }

    private static void test(class_2586 be, Pouches module) {
        Field f;
        if (be != null && (f = Main.traverse(be.getClass())) != null) {
            try {
                f.setAccessible(true);
                VIEWABLE_BLOCKS.put(be.method_11017(), f);
            }
            catch (Exception e) {
                module.logger().error("{}: {}", e.getClass(), (Object)e.getLocalizedMessage());
            }
        }
    }

    @Nullable
    private static Field traverse(Class<?> cls) {
        for (Field f : cls.getDeclaredFields()) {
            if (f.getType() != class_5561.class) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Main.traverse(cls.getSuperclass());
        }
        return null;
    }

    static void testBlocks() {
        Pouches module = ModuleManager.get().get(Pouches.class).orElseThrow();
        for (class_2591 type : class_7923.field_41181) {
            Optional o = type.field_19315.stream().findAny();
            if (o.isPresent()) {
                try {
                    Main.test(type.method_11032(class_2338.field_10980, ((class_2248)o.orElseThrow()).method_9564()), module);
                }
                catch (Exception e) {
                    module.logger().error("{} failed the ViewerCountManager test. {}: {}", (Object)class_7923.field_41181.method_10221((Object)type), (Object)e.getClass().getSimpleName(), (Object)e.getLocalizedMessage());
                }
                continue;
            }
            module.logger().warn("{} has no blocks?", (Object)class_7923.field_41181.method_10221((Object)type));
        }
        if (Util.isDev()) {
            StringBuilder b = new StringBuilder();
            b.append("Viewable block entities:");
            VIEWABLE_VIEW.forEach((blockEntityType, field) -> b.append('\n').append(class_7923.field_41181.method_10221(blockEntityType)).append(": ").append(field.getName()));
            module.logger().info((CharSequence)b);
        }
    }
}

