/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.mechanics.dragon_fight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.mechanics.dragon_fight.DragonFight;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnderDragonManager {
    public static final Codec<EnderDragonManager> CODEC = RecordCodecBuilder.create(data -> data.group((App)Codec.INT.fieldOf("maxPlayers").forGetter(EnderDragonManager::getMaxPlayers), (App)Crystal.CODEC.listOf().fieldOf("crystals").forGetter(EnderDragonManager::getCrystals)).apply((Applicative)data, EnderDragonManager::new));
    public static final Keeper<AttachmentType<EnderDragonManager>> ATTACHMENT = Keeper.create();
    private final List<Crystal> crystals;
    private int maxPlayers;

    public EnderDragonManager(int maxPlayers, List<Crystal> crystals) {
        this.crystals = new ArrayList<Crystal>(crystals);
        this.maxPlayers = Math.max(maxPlayers, 1);
    }

    public void tick(class_3218 world) {
        List dragons = world.method_18776();
        if (dragons.isEmpty()) {
            this.maxPlayers = 1;
            return;
        }
        int i = Math.max(world.method_18456().size(), 1);
        if (i > this.maxPlayers) {
            this.maxPlayers = i;
        }
        HashSet<Crystal> removal = new HashSet<Crystal>();
        for (Crystal pair : this.crystals) {
            if (pair.timer().decrementAndGet() > 0) continue;
            class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
            lightning.method_29498(true);
            lightning.method_23327(pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350);
            world.method_8649((class_1297)lightning);
            class_2675 particleS2CPacket = new class_2675((class_2394)class_2398.field_11207, true, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350, 0.5f, 0.5f, 0.5f, 0.5f, 100);
            for (int j = 0; j < world.method_18456().size(); ++j) {
                class_3222 serverPlayerEntity = (class_3222)world.method_18456().get(j);
                world.method_14191(serverPlayerEntity, true, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350, (class_2596)particleS2CPacket);
            }
            class_1511 endCrystalEntity = new class_1511((class_1937)world, pair.pos().field_1352, pair.pos().field_1351, pair.pos().field_1350);
            world.method_8649((class_1297)endCrystalEntity);
            removal.add(pair);
        }
        this.crystals.removeAll(removal);
        if (!Andromeda.MAIN.get(DragonFight.CONFIG).scaleHealthByMaxPlayers) {
            return;
        }
        for (class_1510 dragon : dragons) {
            class_1324 inst = dragon.method_5996(class_5134.field_23716);
            ((class_1324)MakeSure.notNull((Object)inst, (String)"Ender Dragon has no attributes?")).method_6192(Math.floor(Math.sqrt(500 * this.maxPlayers) * 10.0));
        }
    }

    public void queueRespawn(MutableInt mutableInt, class_243 vec3d) {
        Crystal crystal = new Crystal(mutableInt, vec3d);
        if (!this.crystals.contains(crystal)) {
            this.crystals.add(crystal);
        }
    }

    static void init() {
        ATTACHMENT.init((AttachmentType<EnderDragonManager>)AttachmentRegistry.builder().initializer(() -> new EnderDragonManager(1, Collections.emptyList())).persistent(CODEC).buildAndRegister(Andromeda.id("ender_dragon_data")));
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25181) {
                world.getAttachedOrCreate(ATTACHMENT.get());
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_27983() == class_1937.field_25181) {
                ((EnderDragonManager)world.getAttachedOrCreate(ATTACHMENT.get())).tick(world);
            }
        });
    }

    @Generated
    public List<Crystal> getCrystals() {
        return this.crystals;
    }

    @Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public record Crystal(MutableInt timer, class_243 pos) {
        public static final Codec<Crystal> CODEC = RecordCodecBuilder.create(data -> data.group((App)Codec.INT.fieldOf("timer").xmap(MutableInt::new, MutableInt::getValue).forGetter(Crystal::timer), (App)class_243.field_38277.fieldOf("pos").forGetter(Crystal::pos)).apply((Applicative)data, Crystal::new));
    }
}

