/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.mechanics.trading_goat_horn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.Keeper;
import dev.zenfyr.andromeda.modules.mechanics.trading_goat_horn.GoatHorn;
import dev.zenfyr.pulsar.util.MathUtil;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5268;
import net.minecraft.class_6908;
import net.minecraft.class_7477;
import org.jetbrains.annotations.Nullable;

public class CustomTraderManager {
    public static final Codec<CustomTraderManager> CODEC = RecordCodecBuilder.create(data -> data.group((App)Codec.INT.fieldOf("cooldown").forGetter(CustomTraderManager::getCooldown)).apply((Applicative)data, CustomTraderManager::new));
    public static final Keeper<AttachmentType<CustomTraderManager>> ATTACHMENT = Keeper.create();
    public int cooldown;
    private class_3989 trader;

    public CustomTraderManager(int cooldown) {
        this.cooldown = cooldown;
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.trader != null && this.trader.method_31481()) {
            this.trader = null;
        }
    }

    public void trySpawn(class_3218 world, class_5268 properties, class_1799 stackInHand, class_1657 player, boolean highlight) {
        int tCooldown;
        if (player == null) {
            return;
        }
        if (this.cooldown > 0) {
            if (!highlight || this.trader == null || this.trader.method_31481()) {
                return;
            }
            this.trader.method_6092(new class_1293(class_1294.field_5912, 100, 0, true, false));
            return;
        }
        class_2338 blockPos = player.method_24515();
        class_4153 pointOfInterestStorage = world.method_19494();
        Optional optional = pointOfInterestStorage.method_19127(registryEntry -> registryEntry.method_40225(class_7477.field_39292), pos -> true, blockPos, 48, class_4153.class_4155.field_18489);
        class_2338 blockPos2 = optional.orElse(blockPos);
        class_2338 blockPos3 = this.getNearbySpawnPos((class_4538)world, blockPos2, 48);
        if (blockPos3 == null || !this.doesNotSuffocateAt((class_1922)world, blockPos3)) {
            return;
        }
        if (world.method_23753(blockPos3).method_40220(class_6908.field_37383)) {
            return;
        }
        class_3989 wanderingTraderEntity = (class_3989)class_1299.field_17713.method_47821(world, blockPos3, class_3730.field_16467);
        if (wanderingTraderEntity == null) {
            return;
        }
        this.trader = wanderingTraderEntity;
        this.cooldown = tCooldown = ((GoatHorn.Config)world.am$get(GoatHorn.CONFIG)).cooldown;
        for (int j = 0; j < 2; ++j) {
            this.spawnLlama(world, this.trader);
        }
        properties.method_18040(this.trader.method_5667());
        this.trader.method_18013(tCooldown);
        this.trader.method_18069(blockPos2);
        this.trader.method_18408(blockPos2, 16);
        this.trader.method_6092(new class_1293(class_1294.field_5912, 160, 0, true, false));
    }

    private void spawnLlama(@NonNull class_3218 world, @NonNull class_3989 wanderingTrader) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (wanderingTrader == null) {
            throw new NullPointerException("wanderingTrader is marked non-null but is null");
        }
        class_2338 blockPos = this.getNearbySpawnPos((class_4538)world, wanderingTrader.method_24515(), 4);
        if (blockPos == null) {
            return;
        }
        class_3986 traderLlamaEntity = (class_3986)class_1299.field_17714.method_47821(world, blockPos, class_3730.field_16467);
        if (traderLlamaEntity == null) {
            return;
        }
        traderLlamaEntity.method_5954((class_1297)wanderingTrader, true);
    }

    @Nullable
    private class_2338 getNearbySpawnPos(class_4538 world, class_2338 pos, int range) {
        class_2338 blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pos.method_10263() + MathUtil.threadRandom().nextInt(range * 2) - range;
            class_2338 blockPos2 = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13202, x, z = pos.method_10260() + MathUtil.threadRandom().nextInt(range * 2) - range), z);
            if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)world, (class_2338)blockPos2, (class_1299)class_1299.field_17713)) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    private boolean doesNotSuffocateAt(class_1922 world, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 2, 1))) {
            if (world.method_8320(blockPos).method_26220(world, blockPos).method_1110()) continue;
            return false;
        }
        return true;
    }

    static void init() {
        ATTACHMENT.init((AttachmentType<CustomTraderManager>)AttachmentRegistry.builder().initializer(() -> new CustomTraderManager(0)).persistent(CODEC).buildAndRegister(Andromeda.id("trader_state_manager")));
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (class_1937.field_25179.equals(world.method_27983())) {
                world.getAttachedOrCreate(ATTACHMENT.get());
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (class_1937.field_25179.equals(world.method_27983())) {
                ((CustomTraderManager)world.getAttachedOrCreate(ATTACHMENT.get())).tick();
            }
        });
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }
}

