/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation;

import com.google.gson.JsonElement;
import dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation.AdvancementGeneration;
import dev.zenfyr.andromeda.modules.misc.recipe_advancements_generation.BeforeDataPackSyncEvent;
import dev.zenfyr.pulsar.util.MakeSure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_163;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class Main {
    private static final Map<class_3956<?>, Function<Context, Return>> RECIPE_TYPE_HANDLERS = new HashMap();
    private static final List<BiPredicate<class_2960, class_1860<?>>> FILTERS = Collections.synchronizedList(new ArrayList());

    public static Function<Context, Return> basicConsumer(String typeName, AdvancementGeneration.Config config) {
        return context -> new Return(Main.idFromRecipe(context.id(), typeName), Main.createAdvBuilder(config, context.id(), (class_1856)context.recipe().method_8117().get(0)));
    }

    private static class_2960 idFromRecipe(class_2960 recipe, String typeName) {
        return new class_2960(recipe.method_12836(), "recipes/gen/" + typeName + "/" + recipe.toString().replace(":", "_"));
    }

    public static void addRecipeTypeHandler(class_3956<?> type, Function<Context, Return> consumer) {
        RECIPE_TYPE_HANDLERS.putIfAbsent(type, consumer);
    }

    public static void generateRecipeAdvancements(MinecraftServer server, AdvancementGeneration module, AdvancementGeneration.Config config) {
        ConcurrentHashMap advancementBuilders = new ConcurrentHashMap();
        AtomicInteger count = new AtomicInteger();
        List<CompletableFuture> futures = server.method_3772().method_8126().stream().filter(recipe -> {
            for (BiPredicate<class_2960, class_1860<?>> filter : FILTERS) {
                if (!filter.test(recipe.method_8114(), (class_1860<?>)recipe)) continue;
                return false;
            }
            return true;
        }).map(recipe -> CompletableFuture.runAsync(() -> {
            Function<Context, Return> handler = RECIPE_TYPE_HANDLERS.get(recipe.method_17716());
            if (handler != null) {
                count.getAndIncrement();
                Return r = handler.apply(new Context((class_1860<?>)recipe, recipe.method_8114()));
                if (r != null) {
                    advancementBuilders.put(r.id(), r.builder());
                }
            } else if (!recipe.method_8117().isEmpty()) {
                count.getAndIncrement();
                advancementBuilders.put(new class_2960(recipe.method_8114().method_12836(), "recipes/gen/generic/" + recipe.method_8114().toString().replace(":", "_")), Main.createAdvBuilder(config, recipe.method_8114(), (class_1856[])recipe.method_8117().toArray(class_1856[]::new)));
            }
        }, class_156.method_18349())).toList();
        CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        server.method_18857(future::isDone);
        class_163 advancementManager = server.method_3851().field_13404;
        advancementManager.method_711(advancementBuilders);
        module.logger().info("finished generating {} recipe advancements", (Object)count.get());
        advancementBuilders.clear();
    }

    @NotNull
    public static class_161.class_162 createAdvBuilder(AdvancementGeneration.Config config, class_2960 id, class_1856 ... ingredients) {
        String[][] reqs;
        MakeSure.notEmpty((Object[])ingredients);
        class_161.class_162 builder = class_161.class_162.method_51698();
        builder.method_708(class_2960.method_43902((String)"minecraft", (String)"recipes/root"));
        ArrayList<String> names = new ArrayList<String>();
        HashSet<JsonElement> elements = new HashSet<JsonElement>();
        for (int i = 0; i < ingredients.length; ++i) {
            class_1856 ingredient = ingredients[i];
            if (ingredient.method_8103() || !elements.add(ingredient.method_8089())) continue;
            String name = String.valueOf(i);
            names.add(name);
            builder.method_709(name, (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{new CustomPredicate(ingredient)}));
        }
        builder.method_709("has_recipe", (class_184)new class_2119.class_2121(class_5258.method_27973((class_5341[])new class_5341[0]), id));
        if (config.requireAllItems) {
            reqs = new String[names.size()][2];
            for (int i = 0; i < names.size(); ++i) {
                reqs[i][0] = s = (String)names.get(i);
                reqs[i][1] = "has_recipe";
            }
        } else {
            reqs = new String[1][names.size() + 1];
            for (int i = 0; i < names.size(); ++i) {
                reqs[0][i] = s = (String)names.get(i);
            }
            reqs[0][names.size()] = "has_recipe";
        }
        builder.method_34884(reqs);
        Optional.ofNullable(class_170.class_171.method_753((class_2960)id).method_751()).ifPresent(arg_0 -> ((class_161.class_162)builder).method_706(arg_0));
        return builder;
    }

    static void init(AdvancementGeneration module, AdvancementGeneration.Config config) {
        FILTERS.add((id, recipe) -> config.namespaceBlacklist.contains(id.method_12836()));
        FILTERS.add((id, recipe) -> config.recipeBlacklist.contains(id));
        FILTERS.add((id, recipe) -> recipe.method_8118() && config.ignoreRecipesHiddenInTheRecipeBook);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> Main.generateRecipeAdvancements(server, module, config));
        BeforeDataPackSyncEvent.EVENT.register(server -> Main.generateRecipeAdvancements(server, module, config));
        Main.addRecipeTypeHandler(class_3956.field_17547, Main.basicConsumer("blasting", config));
        Main.addRecipeTypeHandler(class_3956.field_17548, Main.basicConsumer("smoking", config));
        Main.addRecipeTypeHandler(class_3956.field_17546, Main.basicConsumer("smelting", config));
        Main.addRecipeTypeHandler(class_3956.field_17549, Main.basicConsumer("campfire_cooking", config));
        Main.addRecipeTypeHandler(class_3956.field_17641, Main.basicConsumer("stonecutting", config));
        Main.addRecipeTypeHandler(class_3956.field_17545, context -> {
            if (!(context.recipe() instanceof class_1852) && !context.recipe().method_8117().isEmpty()) {
                return new Return(Main.idFromRecipe(context.id(), "crafting"), Main.createAdvBuilder(config, context.id(), (class_1856[])context.recipe().method_8117().toArray(class_1856[]::new)));
            }
            return null;
        });
    }

    static final class CustomPredicate
    extends class_2073 {
        private final class_1856 ingredient;

        CustomPredicate(class_1856 ingredient) {
            this.ingredient = ingredient;
        }

        public boolean method_8970(class_1799 stack) {
            return this.ingredient.method_8093(stack);
        }

        public JsonElement method_8971() {
            return field_9640.method_8971();
        }
    }

    public record Context(class_1860<?> recipe, class_2960 id) {
    }

    public record Return(class_2960 id, class_161.class_162 builder) {
    }
}

