/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.modules.world.crop_temperature;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.common.Andromeda;
import dev.zenfyr.andromeda.common.util.IdentifiedJsonDataLoader;
import dev.zenfyr.andromeda.modules.world.crop_temperature.PlantTemperature;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.codec.ExtraCodecs;
import dev.zenfyr.pulsar.resources.ReloaderType;
import dev.zenfyr.pulsar.resources.ServerReloadersEvent;
import dev.zenfyr.pulsar.util.MathUtil;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4863;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PlantTemperatureData {
    private static final Codec<OldHolder> OLD_CODEC = RecordCodecBuilder.create(data -> data.group((App)ExtraCodecs.optional((String)"replace", (Codec)Codec.BOOL, (Object)false).forGetter(OldHolder::replace), (App)ExtraCodecs.list((Codec)class_7923.field_41175.method_39673()).fieldOf("identifier").forGetter(OldHolder::blocks), (App)Codec.FLOAT.fieldOf("min").forGetter(o -> Float.valueOf(o.temperatures()[1])), (App)Codec.FLOAT.fieldOf("max").forGetter(o -> Float.valueOf(o.temperatures()[2])), (App)Codec.FLOAT.fieldOf("aMin").forGetter(o -> Float.valueOf(o.temperatures()[0])), (App)Codec.FLOAT.fieldOf("aMax").forGetter(o -> Float.valueOf(o.temperatures()[3]))).apply((Applicative)data, (o, blocks, f1, f2, f3, f4) -> new OldHolder((boolean)o, (List<class_2248>)blocks, new float[]{f1.floatValue(), f2.floatValue(), f3.floatValue(), f4.floatValue()})));
    public static final Codec<float[]> FLOAT_ARRAY_CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> {
        if (floats.size() != 4) {
            return DataResult.error(() -> "temperature array must contain exactly 4 floats!");
        }
        return DataResult.success((Object)new FloatArrayList((Collection)floats).toArray(new float[4]));
    }, floats -> Lists.newArrayList((Object[])new Float[]{Float.valueOf(floats[0]), Float.valueOf(floats[1]), Float.valueOf(floats[2]), Float.valueOf(floats[3])}));
    private static final Codec<NewHolder> BASE_HOLDER = RecordCodecBuilder.create(data -> data.group((App)ExtraCodecs.optional((String)"replace", (Codec)Codec.BOOL, (Object)false).forGetter(NewHolder::replace), (App)Codec.unboundedMap((Codec)class_7923.field_41175.method_39673(), FLOAT_ARRAY_CODEC).fieldOf("entries").forGetter(NewHolder::temperatures)).apply((Applicative)data, NewHolder::new));
    private static final Codec<NewHolder> MERGED_CODEC = ExtraCodecs.either((Codec)OLD_CODEC.xmap(pair -> {
        LinkedHashMap<class_2248, float[]> map = new LinkedHashMap<class_2248, float[]>();
        pair.blocks().forEach(block1 -> map.put((class_2248)block1, pair.temperatures));
        return new NewHolder(pair.replace(), map);
    }, newHolder -> new OldHolder(newHolder.replace(), List.copyOf(newHolder.temperatures.keySet()), newHolder.temperatures.values().stream().findFirst().orElseGet(() -> new float[4]))), BASE_HOLDER).xmap(e -> (NewHolder)e.map(Function.identity(), Function.identity()), Either::left);
    public static final ReloaderType<Reloader> RELOADER = ReloaderType.create((class_2960)Andromeda.id("crop_temperatures"));

    public static boolean roll(class_2338 pos, class_2680 state, float temp, class_3218 world) {
        float[] data;
        if (PlantTemperatureData.isPlant(state.method_26204()) && (data = ((Reloader)world.method_8503().pulsar$getReloader(RELOADER)).get(state.method_26204())) != null) {
            if (!((PlantTemperature.Config)world.am$get(PlantTemperature.CONFIG)).available) {
                return true;
            }
            if (temp > data[2] && temp <= data[3] || temp < data[1] && temp >= data[0]) {
                return MathUtil.nextInt((int)0, (int)1) != 0;
            }
            return !(temp > data[3]) && !(temp < data[0]);
        }
        return true;
    }

    public static boolean isPlant(class_2248 block) {
        return block instanceof class_2261 || block instanceof class_4863 || block instanceof class_2256;
    }

    public static void init() {
        PlantTemperature module = ModuleManager.get().get(PlantTemperature.class).orElseThrow();
        ServerReloadersEvent.EVENT.register(context -> context.register((IdentifiableResourceReloadListener)new Reloader(module)));
    }

    private static void verifyPostLoad(PlantTemperature module, Reloader reloader) {
        ArrayList override = new ArrayList();
        ArrayList blocks = new ArrayList();
        class_7923.field_41175.forEach(block -> {
            if (PlantTemperatureData.isPlant(block) && reloader.get((class_2248)block) == null) {
                if (PlantTemperatureData.methodInHierarchyUntil(block.getClass(), "randomTick", class_2248.class)) {
                    override.add(block);
                    return;
                }
                blocks.add(block);
            }
        });
        if (!override.isEmpty()) {
            module.logger().warn("Missing crop temperatures: {}", override.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).sorted().toList());
        }
        if (!blocks.isEmpty()) {
            module.logger().warn("Possible missing crop temperatures: {}", blocks.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).sorted().toList());
        }
    }

    private static boolean methodInHierarchyUntil(Class<?> cls, String name, Class<?> stopClass) {
        if (Arrays.stream(cls.getDeclaredMethods()).anyMatch(method -> method.getName().equals(name))) {
            return true;
        }
        return !stopClass.equals(cls.getSuperclass()) && PlantTemperatureData.methodInHierarchyUntil(cls.getSuperclass(), name, stopClass);
    }

    public static class Reloader
    extends IdentifiedJsonDataLoader {
        @Nullable
        private IdentityHashMap<class_2248, float[]> map;
        private final PlantTemperature module;

        protected Reloader(PlantTemperature module) {
            super(RELOADER.location());
            this.module = module;
        }

        public float @Nullable [] get(class_2248 block) {
            return Objects.requireNonNull(this.map).get(block);
        }

        protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
            IdentityHashMap replace = new IdentityHashMap();
            IdentityHashMap result = new IdentityHashMap();
            Maps.transformValues(data, input -> (NewHolder)MERGED_CODEC.parse((DynamicOps)JsonOps.INSTANCE, input).getOrThrow(false, string -> {
                throw new JsonParseException(string);
            })).values().forEach(newHolder -> {
                if (newHolder.replace()) {
                    replace.putAll(newHolder.temperatures());
                } else {
                    result.putAll(newHolder.temperatures());
                }
            });
            result.putAll(replace);
            this.map = result;
            if (Util.isDev()) {
                PlantTemperatureData.verifyPostLoad(this.module, this);
            }
        }
    }

    record NewHolder(boolean replace, Map<class_2248, float[]> temperatures) {
    }

    record OldHolder(boolean replace, List<class_2248> blocks, float[] temperatures) {
    }
}

