/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.util;

import dev.zenfyr.andromeda.util.FileSystemUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;

public final class ClassPath {
    private final Set<Path> scanned = new HashSet<Path>();
    private final Set<Info> infos = new TreeSet<Info>(Comparator.comparing(info -> info.name));

    public Set<Info> getTopLevelRecursive(String pckg) {
        String s = pckg.replace('/', '.');
        TreeSet<Info> set = new TreeSet<Info>(Comparator.comparing(info -> info.name));
        for (Info info2 : this.infos) {
            if (!info2.getName().startsWith(s)) continue;
            set.add(info2);
        }
        return Collections.unmodifiableSet(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaths(Collection<Path> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (Path path : paths) {
            if (this.scanned.contains(path)) {
                return;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.scan(path);
            } else {
                this.scanJar(path);
            }
            Set<Path> set = this.scanned;
            synchronized (set) {
                this.scanned.add(path);
            }
        }
    }

    private void scanJar(Path path) {
        try (FileSystemUtil.FileSystemDelegate delegate = FileSystemUtil.getJarFileSystem(path, false);){
            this.scan(delegate.get().getRootDirectories().iterator().next());
        }
    }

    private void scan(final Path path) {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String name = path.relativize(file).toString();
                if (name.endsWith(".class") && !name.contains("$")) {
                    String clsName = name.substring(0, name.length() - ".class".length()).replace('\\', '.').replace('/', '.');
                    Set<Info> set = ClassPath.this.infos;
                    synchronized (set) {
                        ClassPath.this.infos.add(new Info(file, clsName));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Generated
    public String toString() {
        return "ClassPath(scanned=" + String.valueOf(this.scanned) + ", infos=" + String.valueOf(this.infos) + ")";
    }

    public static class Info {
        private final Path path;
        private final String name;

        Info(Path path, String name) {
            this.path = path;
            this.name = name;
        }

        public byte[] readAllBytes() throws IOException {
            return Files.readAllBytes(this.path);
        }

        public String packageName() {
            int c = this.name.lastIndexOf(46);
            return c < 0 ? "" : this.name.substring(0, c);
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

