/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.zenfyr.andromeda.bootstrap.ModuleManager;
import dev.zenfyr.andromeda.util.AndromedaConstants;
import dev.zenfyr.andromeda.util.NetUtils;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.util.ExceptionUtil;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import org.apache.logging.log4j.Logger;

public class DataRefreshUtil {
    @Generated
    private static final Logger log = Util.logger();
    private static final Set<String> PRESERVE_KEYS = Sets.newHashSet((Object[])new String[]{"default_branch", "stargazers_count"});
    public static final String OWNER = "constellation-mc";
    public static final String REPO = "andromeda";
    public static final String RAW_URL = "https://raw.githubusercontent.com";
    public static final String API_URL = "https://api.github.com";

    public static String defaultBranch(ModuleManager manager) {
        JsonObject object = manager.dataHolder().getData("git_tracker").getAsJsonObject();
        if (object.has("default_branch")) {
            return object.get("default_branch").getAsString();
        }
        return "1.20-fabric";
    }

    public static boolean modUpdated() {
        return (Boolean)FabricLoader.getInstance().getObjectShare().get(AndromedaConstants.idString("updated"));
    }

    public static void initialize(ModuleManager manager) {
        FabricLoader.getInstance().getObjectShare().put(AndromedaConstants.idString("updated"), (Object)DataRefreshUtil.checkUpdate(manager));
        if (DataRefreshUtil.shouldUpdate(manager)) {
            DataRefreshUtil.tryUpdateGitInfo(manager);
        }
    }

    private static boolean checkUpdate(ModuleManager manager) {
        Version current = manager.modContainer().getMetadata().getVersion();
        if (manager.dataHolder().hasData("last_version")) {
            Version version = (Version)ExceptionUtil.supply(() -> Version.parse((String)manager.dataHolder().getData("last_version").getAsString()));
            if (current.compareTo((Object)version) != 0) {
                log.warn("Andromeda version changed! was [{}], now [{}]", (Object)version.getFriendlyString(), (Object)current.getFriendlyString());
                manager.dataHolder().putData("last_version", current.getFriendlyString()).save();
                return true;
            }
            return false;
        }
        manager.dataHolder().putData("last_version", current.getFriendlyString()).save();
        return true;
    }

    private static boolean shouldUpdate(ModuleManager manager) {
        block5: {
            if (!NetUtils.get().allow) {
                return false;
            }
            if (manager.dataHolder().hasData("git_timestamp")) {
                try {
                    if (ChronoUnit.HOURS.between(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)manager.dataHolder().getData("git_timestamp").getAsString(), Instant::from), Instant.now()) >= 24L) {
                        return true;
                    }
                    break block5;
                }
                catch (Exception ignored) {
                    return DataRefreshUtil.modUpdated();
                }
            }
            return true;
        }
        return DataRefreshUtil.modUpdated();
    }

    private static void tryUpdateGitInfo(ModuleManager manager) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://api.github.com/repos/constellation-mc/andromeda")).header("Accept", "application/vnd.github+json").build();
        try {
            HttpResponse<String> response = NetUtils.get().getClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Status Code: " + response.statusCode() + " Body: " + response.body());
            }
            JsonObject jsonResponse = (JsonObject)JsonParser.parseString((String)response.body());
            Set.copyOf(jsonResponse.keySet()).stream().filter(s -> !PRESERVE_KEYS.contains(s)).forEach(arg_0 -> ((JsonObject)jsonResponse).remove(arg_0));
            manager.dataHolder().putData("git_timestamp", DateTimeFormatter.ISO_INSTANT.format(Instant.now())).putData("git_tracker", (JsonElement)jsonResponse).save();
        }
        catch (Exception e) {
            log.warn("Couldn't update git info", (Throwable)e);
        }
    }
}

