/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import dev.zenfyr.andromeda.util.Util;
import dev.zenfyr.pulsar.util.MakeSure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InstanceDataHolder {
    @Generated
    private static final Logger log = Util.logger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final JsonObject data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceDataHolder putData(String key, JsonElement element) {
        InstanceDataHolder instanceDataHolder = this;
        synchronized (instanceDataHolder) {
            this.data.add(key, element);
            return this;
        }
    }

    public InstanceDataHolder putData(String key, String value) {
        return this.putData(key, (JsonElement)new JsonPrimitive(value));
    }

    public <T> InstanceDataHolder putData(String key, @NotNull Collection<? extends T> collection, Function<? super T, ? extends JsonElement> encoder) {
        if (collection.isEmpty()) {
            return this;
        }
        JsonArray array = new JsonArray();
        for (T t : collection) {
            array.add(encoder.apply(t));
        }
        return this.putData(key, (JsonElement)array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        InstanceDataHolder instanceDataHolder = this;
        synchronized (instanceDataHolder) {
            try (BufferedWriter writer = Files.newBufferedWriter(Util.HIDDEN_PATH.resolve("instance_data.json"), new OpenOption[0]);){
                GSON.toJson((JsonElement)this.data, (Appendable)writer);
            }
            catch (IOException e) {
                throw Util.create("Failed to save instance data!");
            }
        }
    }

    @NotNull
    public JsonElement getData(String string) {
        return (JsonElement)MakeSure.notNull((Object)this.data.get(string), (String)string);
    }

    public boolean hasData(String string) {
        return this.data.has(string);
    }

    public static InstanceDataHolder load() {
        JsonObject holder = new JsonObject();
        Path path = Util.HIDDEN_PATH.resolve("instance_data.json");
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                holder = ((JsonObject)GSON.fromJson((Reader)reader, JsonObject.class)).getAsJsonObject();
            }
            catch (JsonParseException | IOException e) {
                log.error("Failed to load instance data! resetting to default...", e);
            }
        }
        return new InstanceDataHolder(holder);
    }

    @Generated
    public String toString() {
        return "InstanceDataHolder(data=" + String.valueOf(this.data) + ")";
    }

    @Generated
    public InstanceDataHolder(JsonObject data) {
        this.data = data;
    }
}

