/*
 * Decompiled with CFR 0.152.
 */
package dev.zenfyr.andromeda.util;

import com.google.common.base.Splitter;
import dev.zenfyr.pulsar.util.Utilities;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final Splitter SPLITTER = Splitter.on((String)".");
    public static final Path HIDDEN_PATH = FabricLoader.getInstance().getGameDir().resolve(".andromeda");

    public static Logger logger() {
        return LogManager.getLogger((String)Util.getCaller());
    }

    public static boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static RuntimeException create(String msg) {
        return new RuntimeException("(%s) %s".formatted(Util.getCaller(), msg));
    }

    public static RuntimeException create(String msg, Function<String, ? extends RuntimeException> factory) {
        return factory.apply("(%s) %s".formatted(Util.getCaller(), msg));
    }

    public static RuntimeException wrap(String msg, Throwable throwable) {
        return new RuntimeException("(%s) %s".formatted(Util.getCaller(), msg), throwable);
    }

    public static <T extends Throwable> void throwIfDev(Supplier<T> throwable) throws T {
        if (Util.isDev()) {
            throw (Throwable)throwable.get();
        }
    }

    public static <T extends Throwable> void throwNowIfDev(T throwable) throws T {
        if (Util.isDev()) {
            throw throwable;
        }
    }

    private static String getCaller() {
        Class cls = (Class)Utilities.getCallerClass((int)3).orElseThrow();
        List split = SPLITTER.splitToList((CharSequence)cls.getName());
        Object caller = (String)split.get(split.size() - 1);
        caller = "andromeda/" + (String)caller;
        if (cls.getName().startsWith("net.minecraft.")) {
            caller = (String)caller + "@Mixin";
        }
        return caller;
    }
}

