/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.events.SetupAnimCallback;
import chappie.theboys.common.particle.TBParticleTypes;
import chappie.theboys.util.TBCommonUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.joml.Vector3f;

public class FishSwarmAbility
extends Ability
implements IHasTimer {
    public static final int DETECTION_RADIUS = 200;
    private final IHasTimer.Timer timer = new IHasTimer.Timer(() -> 10, () -> ((FishSwarmAbility)this).isEnabled());

    public FishSwarmAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
    }

    public void defineData() {
        super.defineData();
        this.dataManager.define(TBCommonUtil.DISTANCE, (Object)this.entity.method_37908().field_9229.method_39332(50, 100));
    }

    public void update(class_1309 entity, boolean enabled) {
        super.update(entity, enabled);
        if (enabled && entity.method_5799()) {
            double distanceToSurface;
            class_1937 level = entity.method_37908();
            class_2338 playerPos = entity.method_24515();
            double waterSurfaceY = entity.method_23318();
            for (int y = 0; y <= 10; ++y) {
                class_2338 checkPos = playerPos.method_10086(y);
                if (!level.method_8316(checkPos).method_15767(class_3486.field_15517) || level.method_8316(checkPos.method_10084()).method_15767(class_3486.field_15517)) continue;
                waterSurfaceY = (double)checkPos.method_10264() + 1.0;
                break;
            }
            double verticalMotion = (distanceToSurface = waterSurfaceY - Math.ceil(entity.method_23318() + (double)(entity.method_18276() ? -0.75f : 0.0f))) > 2.0 ? 0.2 : (distanceToSurface > 0.5 ? 0.12 : (distanceToSurface > 0.0 ? 0.08 : (distanceToSurface < -0.7 ? -0.05 : 0.02)));
            entity.method_18799(class_243.method_1030((float)0.0f, (float)entity.method_36454()).method_18805(0.75, 0.0, 0.75).method_1031(0.0, verticalMotion, 0.0));
            CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)TBParticleTypes.WATER_SPLASH, (boolean)true, (class_243)entity.method_19538().method_1031(0.0, (double)0.4f, 0.0), (class_243)new class_243(1.0, 0.2, 1.0), (float)1.0f, (int)2);
            CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)TBParticleTypes.WATER_SPLASH, (boolean)true, (class_243)entity.method_19538().method_1031(0.0, (double)0.4f, 0.0), (class_243)new class_243(0.0, 0.0, 0.0), (float)1.0f, (int)5);
        }
    }

    public void initializeClient(Consumer<AbilityClientProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new AbilityClientProperties(){
            private final Map<class_630, Vector3f> savedPose = new HashMap<class_630, Vector3f>();

            public void setupAnim(SetupAnimCallback.SetupAnimEvent event) {
                class_1306 class_13062;
                super.setupAnim(event);
                float ageInTicks = (float)event.entity().field_6012 + event.modelProperties().partialTicks();
                class_1309 entity = event.entity();
                class_572 model = event.model();
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    class_13062 = player.method_6068();
                } else {
                    class_13062 = class_1306.field_6183;
                }
                class_1306 mainArm = class_13062;
                float f = FishSwarmAbility.this.timer.value(event.modelProperties().partialTicks());
                if (f <= 0.001f) {
                    return;
                }
                class_243 motion = entity.method_18798();
                float speed = (float)motion.method_1033();
                float speedFactor = Math.min(speed * 3.0f, 1.0f);
                ArrayList modelPartList = Lists.newArrayList((Object[])new class_630[]{model.field_3391, model.field_27433, model.field_3401, model.field_3397, model.field_3392});
                for (class_630 modelPart : modelPartList) {
                    this.savedPose.put(modelPart, new Vector3f(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674));
                }
                this.applyFullSurfingAnimation((class_572<? extends class_10042>)model, ageInTicks, speedFactor, entity.method_18276(), (class_1297)entity, mainArm == class_1306.field_6182);
                this.savedPose.forEach((part, vec3f) -> part.method_33425(class_3532.method_16439((float)f, (float)vec3f.x, (float)part.field_3654), class_3532.method_16439((float)f, (float)vec3f.y, (float)part.field_3675), class_3532.method_16439((float)f, (float)vec3f.z, (float)part.field_3674)));
            }

            private void applyFullSurfingAnimation(class_572<? extends class_10042> model, float ageInTicks, float speedFactor, boolean isCrouching, class_1297 entity, boolean isLeftHanded) {
                model.field_3391.method_33425(0.0f, 0.0f, 0.0f);
                model.field_27433.method_33425(0.0f, 0.0f, 0.0f);
                model.field_3401.method_33425(0.0f, 0.0f, 0.0f);
                model.field_3397.method_33425(0.0f, 0.0f, 0.0f);
                model.field_3392.method_33425(0.0f, 0.0f, 0.0f);
                model.field_3391.field_3654 -= (float)Math.toRadians(-2.0f - speedFactor * 8.0f);
                model.field_27433.field_3654 = (float)Math.toRadians(-10.0);
                model.field_27433.field_3675 = (float)Math.toRadians(-15.0);
                model.field_27433.field_3674 = (float)Math.toRadians(-12.0);
                model.field_3401.field_3654 = (float)Math.toRadians(-35.0);
                model.field_3401.field_3675 = (float)Math.toRadians(15.0);
                model.field_3401.field_3674 = (float)Math.toRadians(12.0);
                float legBend = 8.0f + speedFactor * 12.0f;
                model.field_3397.field_3654 = (float)Math.toRadians(-legBend);
                model.field_3397.field_3674 = (float)Math.toRadians(-10.0);
                model.field_3392.field_3654 = (float)Math.toRadians(legBend);
                model.field_3392.field_3675 = (float)Math.toRadians(20.0);
                model.field_3392.field_3674 = (float)Math.toRadians(2.0);
                if (isCrouching) {
                    model.field_3391.field_3654 += (float)Math.toRadians(32.0);
                    model.field_3397.field_3654 -= (float)Math.toRadians(18.0);
                    model.field_3392.field_3654 += (float)Math.toRadians(18.0);
                    model.field_27433.field_3654 += (float)Math.toRadians(10.0);
                    model.field_3401.field_3654 += (float)Math.toRadians(10.0);
                }
                float breathCycle = class_3532.method_15374((float)(ageInTicks * 0.04f)) * 0.025f;
                model.field_3391.field_3654 += breathCycle * 0.5f;
                model.field_27433.field_3654 += breathCycle * 0.3f;
                model.field_3401.field_3654 += breathCycle * 0.3f;
                float mainWave = class_3532.method_15374((float)(ageInTicks * 0.12f)) * 0.15f;
                float secondaryWave = class_3532.method_15374((float)(ageInTicks * 0.12f * 2.3f)) * 0.15f * 0.3f;
                float totalWave = (mainWave + secondaryWave) * (0.5f + speedFactor / 2.0f);
                totalWave = isCrouching ? totalWave * 0.7f : totalWave;
                model.field_3391.field_3654 += totalWave * 0.8f;
                model.field_3397.field_3654 -= totalWave * 1.2f;
                model.field_3392.field_3654 -= totalWave * 1.2f;
                model.field_27433.field_3654 -= totalWave * 0.5f;
                model.field_3401.field_3654 -= totalWave * 0.5f;
                float intensity = 0.3f + speedFactor * 0.7f;
                float x = class_3532.method_15374((float)(ageInTicks * 0.51f)) * 0.03f * intensity;
                float z = class_3532.method_15362((float)(ageInTicks * 0.63f)) * 0.03f * intensity;
                model.field_3391.field_3674 += z;
                model.field_27433.field_3674 += z * 0.8f;
                model.field_3401.field_3674 -= z * 0.8f;
                model.field_27433.field_3654 += x * 0.5f;
                model.field_3401.field_3654 -= x * 0.5f;
                this.applyArmBalance(model, ageInTicks, speedFactor);
                this.applyLegBalance(model, ageInTicks, speedFactor, isCrouching);
                if (speedFactor >= 0.1f) {
                    model.field_3391.field_3654 -= speedFactor * 0.15f;
                    model.field_3397.field_3654 += speedFactor * 0.2f;
                    model.field_3392.field_3654 += speedFactor * 0.2f;
                    float speedSway = class_3532.method_15374((float)((float)entity.field_6012 * 0.25f)) * speedFactor * 0.15f;
                    model.field_27433.field_3675 += speedSway;
                    model.field_3401.field_3675 -= speedSway;
                    model.field_27433.field_3674 -= speedFactor * 0.08f;
                    model.field_3401.field_3674 += speedFactor * 0.08f;
                    class_243 motion = entity.method_18798();
                    if (motion.method_1027() > 0.001) {
                        float lateralTilt = (float)motion.field_1352 * 0.3f;
                        model.field_3391.field_3674 += class_3532.method_15363((float)lateralTilt, (float)-0.15f, (float)0.15f);
                    }
                }
                if (Math.abs(entity.method_36454() - entity.field_5982) > 10.0f) {
                    float d = (entity.method_36454() - entity.field_5982) * 0.01f;
                    model.field_27433.field_3674 += d * 0.3f;
                    model.field_3401.field_3674 -= d * 0.3f;
                    model.field_27433.field_3654 -= Math.abs(d) * 0.2f;
                    model.field_3401.field_3654 -= Math.abs(d) * 0.2f;
                    model.field_3391.field_3674 -= d * 0.15f;
                }
                if (isLeftHanded) {
                    Vector3f leftArmRot = new Vector3f(model.field_27433.field_3654, model.field_27433.field_3675, model.field_27433.field_3674);
                    Vector3f leftLegRot = new Vector3f(model.field_3397.field_3654, model.field_3397.field_3675, model.field_3397.field_3674);
                    model.field_27433.method_33425(model.field_3401.field_3654, -model.field_3401.field_3675, -model.field_3401.field_3674);
                    model.field_3397.method_33425(model.field_3392.field_3654, -model.field_3392.field_3675, -model.field_3392.field_3674);
                    model.field_3401.method_33425(leftArmRot.x, -leftArmRot.y, -leftArmRot.z);
                    model.field_3392.method_33425(leftLegRot.x, -leftLegRot.y, -leftLegRot.z);
                    model.field_3391.field_3674 = -model.field_3391.field_3674;
                }
            }

            private void applyArmBalance(class_572<? extends class_10042> model, float ageInTicks, float speedFactor) {
                float armSpeed = 0.08f;
                float intensity = 0.4f + speedFactor * 0.6f;
                float leftArmCycle = class_3532.method_15374((float)(ageInTicks * armSpeed)) * 0.12f * intensity;
                float rightArmCycle = class_3532.method_15374((float)(ageInTicks * armSpeed + (float)Math.PI)) * 0.12f * intensity;
                model.field_27433.field_3654 += leftArmCycle;
                model.field_3401.field_3654 += rightArmCycle;
                model.field_27433.field_3674 += leftArmCycle * 0.6f;
                model.field_3401.field_3674 += rightArmCycle * 0.6f;
                model.field_27433.field_3675 += class_3532.method_15362((float)(ageInTicks * (armSpeed *= 1.3f))) * (intensity *= 0.05f);
                model.field_3401.field_3675 += class_3532.method_15362((float)(ageInTicks * armSpeed + (float)Math.PI)) * intensity;
            }

            private void applyLegBalance(class_572<? extends class_10042> model, float ageInTicks, float speedFactor, boolean isCrouching) {
                float legSpeed = 0.1f;
                float leftLegAdjust = class_3532.method_15374((float)(ageInTicks * legSpeed)) * 0.06f;
                float rightLegAdjust = class_3532.method_15374((float)(ageInTicks * legSpeed + 1.0f)) * 0.06f;
                float intensity = (0.5f + speedFactor * 0.5f) * (isCrouching ? 0.6f : 1.0f);
                model.field_3397.field_3654 += leftLegAdjust * intensity;
                model.field_3392.field_3654 += rightLegAdjust * intensity;
                model.field_3397.field_3675 += leftLegAdjust * 0.3f * intensity;
                model.field_3392.field_3675 += rightLegAdjust * 0.3f * intensity;
                model.field_3397.field_3674 += class_3532.method_15362((float)(ageInTicks * (legSpeed *= 1.5f))) * 0.02f * intensity;
                model.field_3392.field_3674 += class_3532.method_15362((float)(ageInTicks * legSpeed + (float)Math.PI)) * 0.02f * intensity;
            }
        });
    }

    public Iterable<IHasTimer.Timer> timers() {
        return List.of(this.timer);
    }
}

