/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.data.DataAccessor;
import chappie.modulus.util.events.SetupAnimCallback;
import chappie.modulus.util.model.ModelProperties;
import chappie.theboys.common.ability.HeatVisionAbility;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10042;
import net.minecraft.class_10426;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_572;

public class FlightAbility
extends Ability
implements IHasTimer {
    public static final class_4048 FLIGHT_DIMENSIONS = class_4048.method_18384((float)0.6f, (float)0.6f).method_55685(0.51f);
    public static final DataAccessor<Float> SPRINT_SPEED = new DataAccessor("sprint_speed", DataAccessor.DataSerializer.FLOAT);
    public static final DataAccessor<Float> SPEED = new DataAccessor("speed", DataAccessor.DataSerializer.FLOAT);
    public static final DataAccessor<Boolean> BREAK_BLOCKS = new DataAccessor("break_blocks", DataAccessor.DataSerializer.BOOLEAN);
    public static final DataAccessor<Boolean> BOOSTING = new DataAccessor("boosting", DataAccessor.DataSerializer.BOOLEAN);
    public static final DataAccessor<Boolean> SPRINTING = new DataAccessor("sprinting", DataAccessor.DataSerializer.BOOLEAN);
    public static final DataAccessor<Boolean> ARM_AHEAD = new DataAccessor("arm_ahead", DataAccessor.DataSerializer.BOOLEAN);
    public static final DataAccessor<Integer> FORWARD_IMPULSE = new DataAccessor("forward_impulse", DataAccessor.DataSerializer.INT);
    public final IHasTimer.Timer timer = new IHasTimer.Timer(() -> 5, () -> ((FlightAbility)this).isEnabled());
    public final IHasTimer.Timer sprintingTimer = new IHasTimer.Timer(() -> 10, () -> this.isEnabled() && (Boolean)this.dataManager.get(SPRINTING) != false);
    public final IHasTimer.Timer forwardTimer = new IHasTimer.Timer(() -> 5, () -> this.isEnabled() && (Integer)this.dataManager.get(FORWARD_IMPULSE) > 0);
    public final IHasTimer.Timer backwardTimer = new IHasTimer.Timer(() -> 5, () -> this.isEnabled() && (Integer)this.dataManager.get(FORWARD_IMPULSE) < 0);
    public final IHasTimer.Cooldown cooldown = new IHasTimer.Cooldown();

    public FlightAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
    }

    public void defineData() {
        super.defineData();
        this.dataManager.define(SPEED, (Object)Float.valueOf(1.0f));
        this.dataManager.define(SPRINT_SPEED, (Object)Float.valueOf(2.0f));
        this.dataManager.define(BREAK_BLOCKS, (Object)true);
        this.dataManager.define(BOOSTING, (Object)false, false);
        this.dataManager.define(SPRINTING, (Object)false, false);
        this.dataManager.define(ARM_AHEAD, (Object)false, false);
        this.dataManager.define(FORWARD_IMPULSE, (Object)0, false);
    }

    public void onDataUpdated(DataAccessor<?> accessor) {
        super.onDataUpdated(accessor);
        if (accessor == SPRINTING) {
            if (((Boolean)this.dataManager.get(SPRINTING)).booleanValue()) {
                this.dataManager.set(ARM_AHEAD, (Object)(this.entity.method_59922().method_43048(100) < 5 ? 1 : 0));
            } else {
                this.dataManager.set(ARM_AHEAD, (Object)false);
            }
        }
    }

    public void update(class_1309 entity, boolean enabled) {
        super.update(entity, enabled);
        if (enabled) {
            class_243 vec3;
            float speed;
            boolean sprinting;
            if (entity.method_5770().field_9236) {
                float f = entity.field_6250;
                boolean sprinting2 = entity.method_5624();
                if ((Boolean)this.dataManager.get(SPRINTING) != sprinting2) {
                    this.dataManager.setFromClient(SPRINTING, (Object)sprinting2);
                }
                if ((float)((Integer)this.dataManager.get(FORWARD_IMPULSE)).intValue() != f) {
                    this.dataManager.setFromClient(FORWARD_IMPULSE, (Object)Math.round(f));
                }
            }
            boolean bl = sprinting = (Boolean)this.dataManager.get(SPRINTING) != false || entity.method_5624();
            if (!sprinting || (Integer)this.dataManager.get(FORWARD_IMPULSE) <= 0) {
                this.dataManager.set(BOOSTING, (Object)false);
            }
            if (!(entity instanceof class_1657) && this.enabledTicks == 0) {
                entity.method_18799(entity.method_18798().method_1031(0.0, 0.4, 0.0));
            }
            float f = speed = sprinting ? ((Float)this.dataManager.get(SPRINT_SPEED)).floatValue() : ((Float)this.dataManager.get(SPEED)).floatValue();
            if (sprinting) {
                if (this.cooldown.end() && this.conditionManager.test("boost")) {
                    this.cooldown.start(60);
                    this.dataManager.set(BOOSTING, (Object)true);
                    CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)class_2398.field_11236, (boolean)true, (class_243)this.entity.method_19538(), (class_243)class_243.field_1353, (float)1.0f, (int)10);
                }
                if (((Boolean)this.dataManager.get(BOOSTING)).booleanValue()) {
                    speed += this.cooldown.value(1.0f) * 4.0f;
                    CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)class_2398.field_11204, (boolean)true, (class_243)this.entity.method_19538(), (class_243)class_243.field_1353, (float)0.05f, (int)10);
                    if (this.cooldown.timer == 0) {
                        this.dataManager.set(BOOSTING, (Object)false);
                    }
                }
                vec3 = entity.method_18798().method_1021(0.25).method_1019(entity.method_5720().method_1021((double)speed));
            } else {
                this.dataManager.set(BOOSTING, (Object)false);
                vec3 = entity.method_18798().method_18805(1.05, (double)0.1f, 1.05);
                vec3 = vec3.method_1031(0.0, Math.sin((float)entity.field_6012 / 10.0f) / 50.0, 0.0);
                vec3 = vec3.method_1019(this.inputVector(entity, speed * 2.0f));
            }
            entity.method_18799(vec3);
        } else {
            this.dataManager.set(BOOSTING, (Object)false);
        }
    }

    private class_243 inputVector(class_1309 entity, float speedModifier) {
        double d0;
        double yya = entity.field_6250 == 0.0f ? 0.0 : entity.method_5720().field_1351;
        yya = entity.field_6250 < 0.0f ? -yya : yya;
        speedModifier *= 0.01f;
        class_243 vec = new class_243((double)entity.field_6212, yya, (double)entity.field_6250);
        if (entity.field_6212 == 0.0f && entity.field_6250 == 0.0f) {
            vec = entity.method_18798();
        }
        if ((d0 = vec.method_1027()) < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec3 = (d0 > 1.0 ? vec.method_1029() : vec).method_1021((double)speedModifier);
        double f = Math.sin(Math.toRadians(entity.method_36454()));
        double f1 = Math.cos(Math.toRadians(entity.method_36454()));
        return new class_243(vec3.field_1352 * f1 - vec3.field_1350 * f, yya * (double)speedModifier * 16.0, vec3.field_1350 * f1 + vec3.field_1352 * f);
    }

    public boolean causeFallDamage(class_3218 level, class_1309 entity, float fallDistance) {
        boolean sprinting;
        boolean bl = sprinting = (Boolean)this.dataManager.get(SPRINTING) != false || entity.method_5624();
        if (((Boolean)this.dataManager.get(BREAK_BLOCKS)).booleanValue() && fallDistance > 20.0f && (sprinting || !this.isEnabled())) {
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 5; ++y) {
                    for (int z = 0; z < 5; ++z) {
                        double xPos = entity.method_23317() - 2.5 + (double)x + (double)entity.method_5770().field_9229.method_43048(5);
                        double yPos = entity.method_23318() - 2.5 + (double)y + (double)entity.method_5770().field_9229.method_43048(5);
                        double zPos = entity.method_23321() - 2.5 + (double)z + (double)entity.method_5770().field_9229.method_43048(5);
                        class_2338 pos = new class_2338((int)xPos, (int)yPos, (int)zPos);
                        class_2248 block = entity.method_5770().method_8320(pos).method_26204();
                        if (block == class_2246.field_10340) {
                            entity.method_5770().method_8501(pos, class_2246.field_10445.method_9564());
                        } else if (block == class_2246.field_10056) {
                            entity.method_5770().method_8501(pos, class_2246.field_10416.method_9564());
                        } else if (block == class_2246.field_10445) {
                            entity.method_5770().method_8501(pos, class_2246.field_10255.method_9564());
                        } else if (block == class_2246.field_10219) {
                            entity.method_5770().method_8501(pos, class_2246.field_10566.method_9564());
                        } else if (block == class_2246.field_10566) {
                            entity.method_5770().method_8501(pos, class_2246.field_10253.method_9564());
                        } else if (block == class_2246.field_10431) {
                            entity.method_5770().method_8501(pos, class_2246.field_10519.method_9564());
                        } else if (block == class_2246.field_10511) {
                            entity.method_5770().method_8501(pos, class_2246.field_10366.method_9564());
                        } else if (block == class_2246.field_10037) {
                            entity.method_5770().method_8501(pos, class_2246.field_10436.method_9564());
                        } else if (block == class_2246.field_10306) {
                            entity.method_5770().method_8501(pos, class_2246.field_10254.method_9564());
                        } else if (block == class_2246.field_10010) {
                            entity.method_5770().method_8501(pos, class_2246.field_10244.method_9564());
                        } else if (block == class_2246.field_10533) {
                            entity.method_5770().method_8501(pos, class_2246.field_10622.method_9564());
                        } else if (block == class_2246.field_10033) {
                            entity.method_5770().method_22352(pos, false);
                        }
                        level.method_14199((class_2394)class_2398.field_11236, false, false, entity.method_23317(), entity.method_23318() + 0.25, entity.method_23321(), 0, (double)(fallDistance / (float)entity.method_5770().method_31605() * 10.0f), 0.0, 0.0, 1.0);
                        entity.method_5783(class_3417.field_14705, 1.0f, 1.0f);
                    }
                }
            }
        }
        return true;
    }

    public void initializeClient(Consumer<AbilityClientProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new FlightClientProperties(this));
    }

    public List<IHasTimer.Timer> timers() {
        return List.of(this.timer, this.sprintingTimer, this.forwardTimer, this.backwardTimer, this.cooldown);
    }

    public record FlightClientProperties(FlightAbility ability) implements AbilityClientProperties
    {
        public void setupAnim(SetupAnimCallback.SetupAnimEvent event) {
            super.setupAnim(event);
            class_1309 entity = event.entity();
            ModelProperties properties = event.modelProperties();
            class_572 model = event.model();
            float f = this.ability.timer.value(properties.partialTicks());
            float f1 = this.ability.forwardTimer.value(properties.partialTicks());
            float f2 = this.ability.backwardTimer.value(properties.partialTicks());
            float f3 = this.ability.sprintingTimer.value(properties.partialTicks()) * f;
            float f4 = 1.0f - (f1 + f2) / 2.0f;
            float toRad = (float)Math.toRadians(f);
            class_10042 class_100422 = event.state();
            if (!(class_100422 instanceof class_10426)) {
                return;
            }
            class_10426 state = (class_10426)class_100422;
            float bob = class_3532.method_15374((float)(state.field_53328 * 0.067f)) * 0.05f;
            boolean right = !entity.method_6115() && state.field_55304 == class_572.class_573.field_3409 && !state.field_55306.method_30156();
            boolean left = !entity.method_6115() && state.field_55306 == class_572.class_573.field_3409 && !state.field_55304.method_30156();
            model.field_3398.field_3654 /= 1.0f + f;
            model.field_3398.field_3654 += bob * f;
            model.field_3391.field_3656 -= bob * 4.0f * f;
            float f5 = (1.0f - this.ability.sprintingTimer.value(properties.partialTicks())) * f;
            if (right) {
                model.field_3401.field_3654 += bob * 3.0f * f5;
            }
            if (left) {
                model.field_27433.field_3654 += bob * 3.0f * f5;
            }
            model.field_3392.field_3654 -= model.field_3392.field_3654 * f;
            model.field_3392.field_3654 += bob * f;
            model.field_3397.field_3654 -= model.field_3397.field_3654 * f;
            model.field_3397.field_3654 -= bob * f;
            if (f4 != 0.0f) {
                this.setupBaseAnim(model, toRad * f4, right, left);
            }
            if (f1 != 0.0f) {
                this.setupForwardAnim(model, f1, f4, toRad * f1, right, left);
            }
            if (f2 != 0.0f) {
                this.setupBackwardAnim(model, toRad * f2, right, left);
            }
            if (f3 != 0.0f) {
                this.setupSprintingAnim(model, properties.partialTicks(), f3, toRad * f3, right, left);
            }
        }

        public void setupBaseAnim(class_572<?> model, float toRad, boolean right, boolean left) {
            if (right) {
                model.field_3401.field_3675 += 45.0f * toRad;
                model.field_3401.field_3674 += 10.0f * toRad;
            }
            if (left) {
                model.field_27433.field_3675 -= 45.0f * toRad;
                model.field_27433.field_3674 -= 10.0f * toRad;
            }
            model.field_3392.field_3675 += 20.0f * toRad;
            model.field_3392.field_3674 += 5.0f * toRad;
            model.field_3397.field_3675 -= 20.0f * toRad;
            model.field_3397.field_3674 -= 5.0f * toRad;
        }

        public void setupForwardAnim(class_572<?> model, float forwardVal, float sprintVal, float toRad, boolean right, boolean left) {
            model.field_3398.field_3654 -= 8.0f * toRad;
            if (right) {
                model.field_3401.field_3654 += 12.25f * toRad;
                model.field_3401.field_3675 -= 25.0f * toRad;
                model.field_3401.field_3674 += 15.0f * toRad;
            }
            if (left) {
                model.field_27433.field_3654 += 12.25f * toRad;
                model.field_27433.field_3675 += 25.0f * toRad;
                model.field_27433.field_3674 -= 15.0f * toRad;
            }
            model.field_3392.field_3654 -= 5.0f * toRad * sprintVal;
            model.field_3392.field_3675 -= model.field_3392.field_3675 * forwardVal;
            model.field_3392.field_3674 -= model.field_3392.field_3674 * forwardVal;
            model.field_3392.field_3656 -= forwardVal * sprintVal;
            model.field_3392.field_3655 -= 1.5f * forwardVal * sprintVal;
            model.field_3397.field_3654 += 7.5f * toRad;
            model.field_3397.field_3675 -= 27.5f * toRad;
            model.field_3397.field_3674 -= model.field_3397.field_3674 * forwardVal;
        }

        public void setupBackwardAnim(class_572<?> model, float toRad, boolean right, boolean left) {
            model.field_3398.field_3654 += 8.0f * toRad;
            if (right) {
                model.field_3401.field_3654 -= 15.0f * toRad;
                model.field_3401.field_3675 += 22.5f * toRad;
                model.field_3401.field_3674 += 15.0f * toRad;
            }
            if (left) {
                model.field_27433.field_3654 -= 15.0f * toRad;
                model.field_27433.field_3675 -= 22.5f * toRad;
                model.field_27433.field_3674 -= 15.0f * toRad;
            }
            model.field_3392.field_3654 -= 15.0f * toRad;
            model.field_3392.field_3675 += 20.0f * toRad;
            model.field_3392.field_3674 += 7.5f * toRad;
            model.field_3397.field_3654 -= 15.0f * toRad;
            model.field_3397.field_3675 -= 20.0f * toRad;
            model.field_3397.field_3674 -= 7.5f * toRad;
        }

        public void setupSprintingAnim(class_572<?> model, float partialTicks, float sprintVal, float toRad, boolean right, boolean left) {
            model.field_3398.field_3654 -= model.field_3398.field_3654 * sprintVal + sprintVal;
            if (((Boolean)this.ability.dataManager.get(ARM_AHEAD)).booleanValue()) {
                if (right) {
                    model.field_3401.field_3654 -= 195.0f * toRad;
                    model.field_3401.field_3675 += 20.0f * toRad;
                    model.field_3401.field_3674 -= 30.0f * toRad;
                }
                if (left) {
                    model.field_27433.field_3654 -= 12.25f * toRad;
                    model.field_27433.field_3674 += 15.0f * toRad;
                }
            }
            for (HeatVisionAbility heatVisionAbility : CommonUtil.listOfType(HeatVisionAbility.class, (Collection)CommonUtil.getAbilities((class_1297)this.ability().entity))) {
                float f = heatVisionAbility.eyesTimer.value(partialTicks);
                model.field_3398.field_3654 -= sprintVal * f * 0.5f;
                if (right) {
                    model.field_3401.field_3654 -= model.field_3401.field_3654 * f;
                    model.field_3401.field_3675 -= model.field_3401.field_3675 * f;
                    model.field_3401.field_3674 -= model.field_3401.field_3674 * f;
                }
                if (!left) continue;
                model.field_27433.field_3654 -= model.field_27433.field_3654 * f;
                model.field_27433.field_3675 -= model.field_27433.field_3675 * f;
                model.field_27433.field_3674 -= model.field_27433.field_3674 * f;
            }
            model.field_3397.field_3654 -= model.field_3397.field_3654 * sprintVal;
            model.field_3397.field_3675 -= model.field_3397.field_3675 * sprintVal;
            model.field_3397.field_3674 -= model.field_3397.field_3674 * sprintVal;
            model.field_3392.field_3654 -= model.field_3392.field_3654 * sprintVal;
            model.field_3392.field_3675 -= model.field_3392.field_3675 * sprintVal;
            model.field_3392.field_3674 -= model.field_3392.field_3674 * sprintVal;
        }
    }
}

