/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.common.ability.base.AbilityType;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.common.ability.base.condition.KeyCondition;
import chappie.modulus.util.ClientUtil;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.data.DataAccessor;
import chappie.modulus.util.model.ModelProperties;
import chappie.theboys.common.ability.GlowEyesAbility;
import chappie.theboys.common.ability.base.TBAbilityTypes;
import chappie.theboys.common.capability.TheBoysCap;
import chappie.theboys.common.particle.LaserParticle;
import chappie.theboys.util.TBCommonUtil;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_922;

public class HeatVisionAbility
extends GlowEyesAbility {
    public static final DataAccessor<Integer> MAX_TIMER = new DataAccessor("max_timer", DataAccessor.DataSerializer.INT);
    public static final DataAccessor<Float> DISTANCE = new DataAccessor("distance", DataAccessor.DataSerializer.FLOAT);
    public static final DataAccessor<Float> STRENGTH = new DataAccessor("strength", DataAccessor.DataSerializer.FLOAT);
    public final IHasTimer.Timer timer = new IHasTimer.Timer(() -> (Integer)this.dataManager.get(MAX_TIMER), () -> ((HeatVisionAbility)this).isEnabled());
    private Map.Entry<class_2338, Integer> blocksInFire;

    public HeatVisionAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
        this.eyesTimer = new IHasTimer.Timer(() -> 4, () -> !(this.entity instanceof class_1657) && this.isEnabled() || this.conditionManager.test("eyes"));
    }

    public static AbilityBuilder of(String id, Function<KeyCondition, KeyCondition> consumer, Function<KeyCondition, KeyCondition> additionalConsumer) {
        return AbilityBuilder.of((String)id, (AbilityType)TBAbilityTypes.HEAT_VISION).condition(a -> (Condition)consumer.apply(new KeyCondition((Ability)a, (Ability)a){
            final /* synthetic */ Ability val$a;
            {
                this.val$a = ability2;
                super(ability);
            }

            public boolean get() {
                if (this.val$a.enabledTicks >= (Integer)this.val$a.dataManager.get(MAX_TIMER) && this.val$a.conditionManager.conditionsFor("enabling").stream().noneMatch(enabling -> enabling != this && !enabling.get())) {
                    return true;
                }
                return super.get();
            }
        }), new String[]{"enabling", "eyes"}).condition(a -> (Condition)additionalConsumer.apply(new KeyCondition(a)), new String[]{"enabling"});
    }

    @Override
    public void defineData() {
        super.defineData();
        this.dataManager.define(MAX_TIMER, (Object)4);
        this.dataManager.define(DISTANCE, (Object)Float.valueOf(20.0f)).define(STRENGTH, (Object)Float.valueOf(1.0f));
    }

    public void update(class_1309 entity, boolean enabled) {
        class_239 hitResult;
        super.update(entity, enabled);
        if (!entity.method_5770().field_9236 && this.enabledTicks >= (Integer)this.dataManager.get(MAX_TIMER) && (hitResult = CommonUtil.pick((class_1297)entity, (double)((Float)this.dataManager.get(DISTANCE)).floatValue())).method_17783() != class_239.class_240.field_1333) {
            class_3966 rtr;
            if (hitResult instanceof class_3966 && (rtr = (class_3966)hitResult).method_17782() != entity) {
                this.onHitEntity(rtr);
            } else if (hitResult instanceof class_3965) {
                class_3965 rtr2 = (class_3965)hitResult;
                this.onHitBlock(rtr2);
            }
            CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)new LaserParticle.LaserParticleOptions(this.entity.method_5628(), Color.WHITE.getRGB()), (boolean)true, (class_243)hitResult.method_17784(), (class_243)new class_243(entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4), (float)0.01f, (int)1);
            CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)new LaserParticle.LaserParticleOptions(this.entity.method_5628(), ((Color)this.dataManager.get(TBCommonUtil.COLOR)).getRGB()), (boolean)true, (class_243)hitResult.method_17784(), (class_243)new class_243(entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4), (float)0.04f, (int)4);
            CommonUtil.spawnParticleForAll((class_1937)this.entity.method_5770(), (class_2394)class_2398.field_11251, (boolean)true, (class_243)hitResult.method_17784(), (class_243)new class_243(entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4, entity.method_59922().method_43059() * 5.0E-4), (float)0.03f, (int)10);
        }
    }

    @Override
    public void initializeClient(Consumer<AbilityClientProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new AbilityClientProperties(){

            public void render(class_922<? extends class_1309, ? extends class_10042, ? extends class_583<?>> renderer, class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1309 entity, ModelProperties modelProperties) {
                if (!modelProperties.root().method_41919("head")) {
                    return;
                }
                Color color = (Color)HeatVisionAbility.this.dataManager.get(TBCommonUtil.COLOR);
                float red = (float)color.getRed() / 255.0f;
                float green = (float)color.getGreen() / 255.0f;
                float blue = (float)color.getBlue() / 255.0f;
                boolean humanoid = renderer.method_4038() instanceof class_572;
                poseStack.method_22903();
                class_239 hitResult = CommonUtil.pick((class_1297)entity, (double)((Float)HeatVisionAbility.this.dataManager.get(DISTANCE)).floatValue());
                double distance = entity.method_33571().method_1022(hitResult.method_17784());
                float f = HeatVisionAbility.this.timer.value(modelProperties.partialTicks());
                if (f != 0.0f) {
                    float y = humanoid ? 0.25f : 0.0f;
                    for (int i = 0; i < 2; ++i) {
                        float x = i == 0 ? 0.15f : -0.15f;
                        class_238 box = new class_238((double)x, (double)(-y), -0.25, 0.0, (double)(-y), -0.25 + -distance * (double)f).method_1014(0.03);
                        poseStack.method_22903();
                        modelProperties.root().method_32086("head").method_22703(poseStack);
                        TheBoysCap cap = TheBoysCap.getCap(entity);
                        if (cap != null) {
                            float f2 = cap.eyesHeight() - 5;
                            poseStack.method_46416(0.0f, f2 * 0.0625f, 0.0f);
                            float f1 = cap.eyesLength();
                            float f3 = f1 == 1.0f ? 0.0f : (f1 == 2.0f ? 0.25f : 0.0625f * (8.25f - (3.0f - f1) * 4.25f));
                            poseStack.method_46416(0.0f, f3, 0.0f);
                            poseStack.method_22905(1.0f, f1, 1.0f);
                        }
                        poseStack.method_22905(0.5f, 0.75f, 1.0f);
                        poseStack.method_22904((double)x, -0.05, 0.0);
                        ClientUtil.renderFilledBox((class_4587)poseStack, (class_4588)bufferIn.getBuffer(ClientUtil.ModRenderTypes.MAIN_LASER), (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)f, (int)packedLightIn);
                        class_4588 vertexConsumer = bufferIn.getBuffer(ClientUtil.ModRenderTypes.LASER);
                        ClientUtil.renderFilledBox((class_4587)poseStack, (class_4588)vertexConsumer, (class_238)box.method_1014(0.015), (float)red, (float)green, (float)blue, (float)(f * 0.2f), (int)packedLightIn);
                        ClientUtil.renderFilledBox((class_4587)poseStack, (class_4588)vertexConsumer, (class_238)box.method_1014(0.03), (float)red, (float)green, (float)blue, (float)(f * 0.2f), (int)packedLightIn);
                        poseStack.method_22909();
                    }
                }
                poseStack.method_22909();
            }
        });
    }

    protected void onHitEntity(class_3966 hitResult) {
        float strength = ((Float)this.dataManager.get(STRENGTH)).floatValue();
        hitResult.method_17782().method_20803(60 + (int)(strength * 5.0f));
        class_1937 class_19372 = this.entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            hitResult.method_17782().method_64397(serverLevel, this.entity.method_48923().method_48812(this.entity), strength * 2.0f);
        }
    }

    protected void onHitBlock(class_3965 hitResult) {
        class_2338 blockPos = hitResult.method_17777();
        if (this.entity.method_5770().method_8320(blockPos).method_26204() == class_2246.field_10102) {
            if (this.blocksInFire == null || !this.blocksInFire.getKey().equals((Object)blockPos)) {
                this.blocksInFire = new AbstractMap.SimpleEntry<class_2338, Integer>(blockPos, 0);
            }
            this.blocksInFire.setValue(this.blocksInFire.getValue() + 1);
            if (this.blocksInFire.getValue() > 60) {
                this.entity.method_5770().method_8652(blockPos, class_2246.field_10033.method_9564(), 11);
                this.blocksInFire = null;
            }
        } else {
            blockPos = blockPos.method_10093(hitResult.method_17780());
            if (this.entity.method_5770().method_22347(blockPos)) {
                if (this.blocksInFire == null || !this.blocksInFire.getKey().equals((Object)blockPos)) {
                    this.blocksInFire = new AbstractMap.SimpleEntry<class_2338, Integer>(blockPos, 0);
                }
                this.blocksInFire.setValue(this.blocksInFire.getValue() + 1);
                if (this.blocksInFire.getValue() > 3) {
                    this.entity.method_5770().method_8652(blockPos, class_2246.field_10036.method_9564(), 11);
                    this.blocksInFire = null;
                }
            }
        }
    }

    @Override
    public Iterable<IHasTimer.Timer> timers() {
        return Iterables.concat(super.timers(), List.of(this.timer));
    }
}

