/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.data.DataAccessor;
import chappie.theboys.common.capability.TheBoysCap;
import chappie.theboys.common.entity.TrailEntity;
import chappie.theboys.util.TBCommonUtil;
import chappie.theboys.util.interfaces.ILivingEntityEx;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_5134;

public class SpeedAbility
extends Ability
implements IHasTimer {
    public static final class_265 STABLE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.25, (double)16.0);
    public static final DataAccessor<Integer> TRAIL_DURATION = new DataAccessor("trail_duration", DataAccessor.DataSerializer.INT);
    public static final DataAccessor<Integer> MAX_SPEED_LVL = new DataAccessor("max_speed_lvl", DataAccessor.DataSerializer.INT);
    public static final DataAccessor<Integer> SPEED_LVL = new DataAccessor("speed_lvl", DataAccessor.DataSerializer.INT);
    private final IHasTimer.Cooldown upgradeCooldown = new IHasTimer.Cooldown();
    private final IHasTimer.Cooldown cooldown = new IHasTimer.Cooldown();
    private double xOld;
    private double zOld;

    public SpeedAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
    }

    public void defineData() {
        super.defineData();
        this.dataManager.define(TBCommonUtil.COLOR, (Object)Color.BLUE);
        this.dataManager.define(TRAIL_DURATION, (Object)10);
        this.dataManager.define(SPEED_LVL, (Object)1);
        this.dataManager.define(MAX_SPEED_LVL, (Object)10);
    }

    public void update(class_1309 entity, boolean enabled) {
        super.update(entity, enabled);
        if (entity.method_5770().field_9236) {
            return;
        }
        for (IHasTimer.Timer timer : this.timers()) {
            timer.update();
        }
        if (enabled && !entity.method_5681() && !entity.method_6128() && entity instanceof ILivingEntityEx) {
            boolean isMoving;
            ILivingEntityEx ex = (ILivingEntityEx)entity;
            int speedLevel = (Integer)this.dataManager.get(SPEED_LVL);
            double scale = Math.pow(10.0, 3.0);
            double x = Math.ceil(ex.theBoys$oldPos().field_1352 * scale) / scale;
            double x1 = Math.ceil(entity.method_23317() * scale) / scale;
            double z = Math.ceil(ex.theBoys$oldPos().field_1350 * scale) / scale;
            double z1 = Math.ceil(entity.method_23321() * scale) / scale;
            boolean bl = isMoving = x != x1 || z != z1;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.field_6012 % 100 == 0) {
                    player.method_7344().method_7585(1, 1.0f);
                }
            }
            this.setAttribute(entity, this.builder.id, class_5134.field_23719, speedLevel, class_1322.class_1323.field_6331);
            this.setAttribute(entity, this.builder.id, class_5134.field_23723, speedLevel, class_1322.class_1323.field_6331);
            if (isMoving && !entity.method_5765()) {
                this.setupTrail(entity, speedLevel);
                if (this.upgradeCooldown.end() && speedLevel < this.getMaxSpeedLevel()) {
                    this.dataManager.set(SPEED_LVL, (Object)(speedLevel + 1));
                    this.upgradeCooldown.start((Integer)this.dataManager.get(SPEED_LVL) * 10);
                }
            } else if (this.cooldown.end() && speedLevel > 1) {
                this.dataManager.set(SPEED_LVL, (Object)(speedLevel - 1));
                this.cooldown.start(((Integer)this.dataManager.get(SPEED_LVL)).intValue());
            }
            if (entity.method_5624() && speedLevel > 5 && isMoving) {
                for (class_1309 e : entity.method_5770().method_18467(class_1309.class, CommonUtil.boxWithRange((class_243)entity.method_19538(), (double)0.5))) {
                    if (e == entity) continue;
                    e.method_5643(e.method_48923().method_48822(), (float)speedLevel);
                }
            }
        } else {
            this.dataManager.set(SPEED_LVL, (Object)1);
            this.setAttribute(entity, this.builder.id, class_5134.field_23719, 0.0, class_1322.class_1323.field_6331);
            this.setAttribute(entity, this.builder.id, class_5134.field_23723, 0.0, class_1322.class_1323.field_6331);
            this.upgradeCooldown.timer = 0;
            this.cooldown.timer = 0;
        }
    }

    private void setupTrail(class_1309 entity, int speedLevel) {
        if (entity.method_5767() || !(entity instanceof ILivingEntityEx)) {
            return;
        }
        ILivingEntityEx ex = (ILivingEntityEx)entity;
        float distanceForTrail = 2.0f - (float)speedLevel / ((float)((Integer)this.dataManager.get(MAX_SPEED_LVL)).intValue() * 2.0f);
        if (this.xOld == 0.0 || this.zOld == 0.0) {
            this.xOld = ex.theBoys$oldPos().field_1352;
            this.zOld = ex.theBoys$oldPos().field_1350;
        }
        if (Math.abs(entity.method_23317() - this.xOld) >= (double)distanceForTrail || Math.abs(entity.method_23321() - this.zOld) >= (double)distanceForTrail) {
            this.xOld = ex.theBoys$oldPos().field_1352;
            this.zOld = ex.theBoys$oldPos().field_1350;
            entity.method_5770().method_8649((class_1297)new TrailEntity(entity.method_5770(), entity, Color.WHITE, (Integer)this.dataManager.get(TRAIL_DURATION)));
        }
    }

    public int getMaxSpeedLevel() {
        int speedLevel = (Integer)this.dataManager.get(MAX_SPEED_LVL);
        TheBoysCap cap = TheBoysCap.getCap(this.entity);
        if (cap != null && cap.compoundV()) {
            speedLevel = (int)((float)speedLevel * 1.5f);
        }
        return speedLevel;
    }

    public void setAttribute(class_1309 entity, String name, class_1320 attribute, double amount, class_1322.class_1323 operation) {
        class_1324 instance = entity.method_5996(attribute);
        UUID uuid = UUID.fromString("fefb466b-f73a-4e1d-8bac-77f702d2b437");
        if (instance != null) {
            class_1322 modifier = instance.method_6199(uuid);
            if (modifier != null && modifier.method_6186() != amount) {
                instance.method_6200(uuid);
                modifier = null;
            }
            if (modifier == null && amount != 0.0) {
                instance.method_26835(new class_1322(uuid, name, amount, operation));
            }
        }
    }

    public Iterable<IHasTimer.Timer> timers() {
        return List.of(this.cooldown, this.upgradeCooldown);
    }
}

