/*
 * Decompiled with CFR 0.152.
 */
package chappie.theboys.common.ability;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.data.DataAccessor;
import chappie.theboys.TheBoys;
import chappie.theboys.common.capability.TBEntityCap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5698;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5745;
import net.minecraft.class_6862;
import net.minecraft.class_7269;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SuperHearingAbility
extends Ability
implements IHasTimer,
class_8514 {
    public static final DataAccessor<Integer> RECEIVED = new DataAccessor("received", DataAccessor.DataSerializer.INT);
    public final class_5715<class_8514.class_8516> dynamicGameEventListener;
    private final class_8514.class_5719 vibrationUser;
    public IHasTimer.Timer timer = new IHasTimer.Timer(() -> 10, () -> ((SuperHearingAbility)this).isEnabled());
    private class_8514.class_8515 vibrationData = new class_8514.class_8515();

    public SuperHearingAbility(class_1309 entity, AbilityBuilder builder) {
        super(entity, builder);
        this.vibrationUser = new VibrationUser(this);
        this.dynamicGameEventListener = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
    }

    public void defineData() {
        super.defineData();
        this.dataManager.define(RECEIVED, (Object)0);
    }

    public void update(class_1309 entity, boolean enabled) {
        super.update(entity, enabled);
        if (!entity.method_37908().method_8608()) {
            this.tick(entity.method_37908(), this.vibrationData, this.vibrationUser);
        }
        if ((Integer)this.dataManager.get(RECEIVED) > 0) {
            this.dataManager.set(RECEIVED, (Object)((Integer)this.dataManager.get(RECEIVED) - 1));
        }
    }

    public List<IHasTimer.Timer> timers() {
        return List.of(this.timer);
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)TheBoys.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.method_10566("listener", tag1));
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        if (tag.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)TheBoys.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    void tick(class_1937 level, class_8514.class_8515 data, class_8514.class_5719 user) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (data.method_51394() == null) {
                this.trySelectAndScheduleVibration(serverLevel, data, user);
            }
            if (data.method_51394() != null) {
                boolean bl = data.method_51395() > 0;
                this.tryReloadVibrationParticle(serverLevel, data, user);
                data.method_51396();
                if (data.method_51395() <= 0) {
                    bl = this.receiveVibration(serverLevel, data, user, data.method_51394());
                }
                if (bl) {
                    user.method_42672();
                }
            }
        }
    }

    private void trySelectAndScheduleVibration(class_3218 level, class_8514.class_8515 data, class_8514.class_5719 user) {
        data.method_51387().method_45502(level.method_8510()).ifPresent(vibrationInfo -> {
            data.method_51390(vibrationInfo);
            class_243 vec3 = vibrationInfo.comp_659();
            data.method_51388(user.method_51410(vibrationInfo.comp_658()));
            class_5745 option = new class_5745(user.method_51300(), data.method_51395());
            class_1309 patt0$temp = this.entity;
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                level.method_14166(player, (class_2394)option, false, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            } else {
                level.method_14199((class_2394)option, vec3.field_1352, vec3.field_1351, vec3.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
            user.method_42672();
            data.method_51387().method_45501();
        });
    }

    private void tryReloadVibrationParticle(class_3218 level, class_8514.class_8515 data, class_8514.class_5719 user) {
        if (data.method_51397()) {
            if (data.method_51394() == null) {
                data.method_51393(false);
            } else {
                class_243 vec3 = data.method_51394().comp_659();
                class_5716 positionSource = user.method_51300();
                class_243 vec32 = positionSource.method_32956((class_1937)level).orElse(vec3);
                int i = data.method_51395();
                int j = user.method_51410(data.method_51394().comp_658());
                double d = 1.0 - (double)i / (double)j;
                double e = class_3532.method_16436((double)d, (double)vec3.field_1352, (double)vec32.field_1352);
                double f = class_3532.method_16436((double)d, (double)vec3.field_1351, (double)vec32.field_1351);
                double g = class_3532.method_16436((double)d, (double)vec3.field_1350, (double)vec32.field_1350);
                class_5745 option = new class_5745(positionSource, i);
                class_1309 class_13092 = this.entity;
                if (class_13092 instanceof class_3222) {
                    class_3222 player = (class_3222)class_13092;
                    level.method_14166(player, (class_2394)option, false, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
                } else {
                    level.method_14199((class_2394)option, e, f, g, 1, 0.0, 0.0, 0.0, 0.0);
                }
                data.method_51393(false);
            }
        }
    }

    private boolean receiveVibration(class_3218 level, class_8514.class_8515 data, class_8514.class_5719 user, class_7269 vibrationInfo) {
        class_2338 blockPos = class_2338.method_49638((class_2374)vibrationInfo.comp_659());
        class_2338 blockPos2 = user.method_51300().method_32956((class_1937)level).map(class_2338::method_49638).orElse(blockPos);
        if (user.method_51363() && !this.areAdjacentChunksTicking((class_1937)level, blockPos2)) {
            return false;
        }
        user.method_32969(level, blockPos, vibrationInfo.comp_657(), (class_1297)vibrationInfo.method_42348(level).orElse(null), (class_1297)vibrationInfo.method_42687(level).orElse(null), class_8514.class_8516.method_51402((class_2338)blockPos, (class_2338)blockPos2));
        data.method_51390(null);
        return true;
    }

    private boolean areAdjacentChunksTicking(class_1937 level, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        for (int i = chunkPos.field_9181 - 1; i <= chunkPos.field_9181 + 1; ++i) {
            for (int j = chunkPos.field_9180 - 1; j <= chunkPos.field_9180 + 1; ++j) {
                if (level.method_39425(class_1923.method_8331((int)i, (int)j)) && level.method_8398().method_21730(i, j) != null) continue;
                return false;
            }
        }
        return true;
    }

    static class VibrationUser
    implements class_8514.class_5719 {
        private final class_5716 positionSource;
        private final SuperHearingAbility ability;

        public VibrationUser(SuperHearingAbility ability) {
            this.ability = ability;
            this.positionSource = new class_5709((class_1297)this.ability.entity, this.ability.entity.method_5751() / 2.0f);
        }

        public int method_49797() {
            return 40;
        }

        public int method_51410(float distance) {
            return super.method_51410(distance) * 2;
        }

        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(class_3218 level, class_2338 pos, class_5712 gameEvent, class_5712.class_7397 context) {
            class_1309 entity = this.ability.entity;
            if (!entity.method_29504() && this.ability.isEnabled() && level.method_8621().method_11952(pos)) {
                class_1297 class_12972 = context.comp_713();
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)class_12972;
                    boolean b = entity.method_37908() == livingEntity.method_37908() && class_1301.field_6156.test(livingEntity) && !entity.method_5722((class_1297)livingEntity) && livingEntity.method_5864() != class_1299.field_6131 && !livingEntity.method_5655() && !livingEntity.method_29504() && entity.method_37908().method_8621().method_11966(livingEntity.method_5829());
                    return b && !livingEntity.method_5779((class_1297)entity);
                }
                return true;
            }
            return false;
        }

        public void method_32969(class_3218 level, class_2338 pos, class_5712 gameEvent, @Nullable class_1297 entity, @Nullable class_1297 playerEntity, float distance) {
            TBEntityCap cap;
            if (entity != null && (cap = TBEntityCap.getCap(entity)) != null) {
                cap.setGlowingTick(20);
            }
            this.ability.dataManager.set(RECEIVED, (Object)10);
        }

        public class_6862<class_5712> method_42210() {
            return class_5698.field_28090;
        }
    }
}

